% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{KHCE}
\alias{KHCE}
\title{Kidney Hierarchical Composite Endpoint dataset.}
\format{
a data frame with 1500 rows and 11 variables:
\describe{
\item{ID}{patient identifiers, numeric}
\item{TRTPN}{treatment values, 1 Active or 2 Placebo, numeric}
\item{AVAL0}{original values for each type of the event, time for TTE outcomes 1-6, numeric values for Continuous outcome 7, numeric}
\item{AVAL}{\code{AVAL = AVAL0 + GROUPN}, ordinal analysis values for the HCE analysis, numeric, but caution NOT to apply numeric operations; will give meaningless results}
\item{GROUP}{name of the event, character}
\item{GROUPN}{ordinal outcomes corresponding to \code{PARAMN} values, numeric}
\item{PARAMCD}{coded name of the event, character}
\item{PARAMN}{severity of the event, outcomes 1-7, where a higher value means a better outcome, character}
\item{STRATAN}{strata 1-4, higher value means more severe kidney disease, numeric}
\item{EGFRBL}{Baseline GFR values of patients, numeric}
\item{TRTP}{treatment values, A Active or P Placebo, character}
\item{PADY}{primary analysis day (in years), length of the fixed follow-up, numeric}
}
}
\source{
Heerspink HL et al "Development and validation of a new hierarchical composite endpoint for clinical trials of kidney disease progression." Journal of the American Society of Nephrology (2023): \url{doi:10.1681/ASN.0000000000000243}.
}
\usage{
KHCE
}
\description{
A dataset with kidney ordinal scale outcomes of 1500 patients in the \code{ADSL} dataset.
}
\examples{
# Adjusted win odds
res <- regWO(x = KHCE, AVAL = "AVAL", TRTP = "TRTP", COVAR = "STRATAN", ref = "P")
res
# Convert the dataset to an adhce object.
## First check that `GROUP` is a factor with the correct ordering of outcomes.
class(KHCE$GROUP) # "factor"
levels(KHCE$GROUP)
dat1 <- as_hce(KHCE)
class(dat1)
calcWO(dat1)
## Re-derive individual patient eGFR slopes using a linear regression model, 
## based on the eGFR measurements in the `ADLB` dataset
dat2 <- KHCE
l <- lapply(
split(ADLB, ADLB$ID), 
function(x) coef(lm(AVAL ~ ADAY, data = x))[2])
new_slopes <- do.call(rbind, l)
new_slopes <- as.data.frame(new_slopes)
names(new_slopes) <- "LINEAR"
new_slopes$ID <- as.numeric(row.names(new_slopes))
dat2 <- merge(KHCE, new_slopes, by = "ID", all.x = TRUE)
dat2$AVAL0[dat2$PARAMCD == "eGFR"] <- dat2$LINEAR[dat2$PARAMCD == "eGFR"]
dat2$AVAL0[is.na(dat2$AVAL0)] <- 0 
dat2 <- as_hce(dat2)
calcWO(dat2)
}
\keyword{datasets}
