% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hawkes_ogata.R
\name{hawkes_ogata}
\alias{hawkes_ogata}
\title{Simulation of a Hawkes process}
\usage{
hawkes_ogata(end, lambda, alpha, beta, lambda0 = NULL)
}
\arguments{
\item{end}{Right bound on time.}

\item{lambda}{Baseline intensity.}

\item{alpha}{Parameter for the amplitude of the spike.}

\item{beta}{Parameter for the speed of exponential decay.}

\item{lambda0}{(Optional) Initial value of the conditional intensity.}
}
\value{
A S3 object of class Hawkes containing a vector ($p) of simulated values,
and all other objects used for the simulation.
}
\description{
Simulates a Hawkes process via Ogata's modified thinning algorithm on \eqn{[0,\mathrm{end}]}.
This is less efficient than function \code{hawkes}, but can be useful for pedagogical reasons.
}
\examples{
# Simulate an exponential Hawkes process with baseline intensity 1 and
# excitation function 1*exp(-2t)
x <- hawkes_ogata(10, 1, 1, 2)
plot(x)
}
