% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwbr.R
\name{gwbr}
\alias{gwbr}
\title{Geographically Weighted  Beta Regression}
\usage{
gwbr(
  yvar,
  xvar,
  lat,
  long,
  h,
  data,
  xglobal = NA_character_,
  grid = data.frame(),
  method = c("fixed_g", "fixed_bsq", "adaptative_bsq"),
  link = c("logit", "probit", "loglog", "cloglog"),
  distancekm = TRUE,
  global = FALSE,
  maxint = 100
)
}
\arguments{
\item{yvar}{A vector with the response variable name.}

\item{xvar}{A vector with descriptive variable(s) name(s).}

\item{lat}{A vector with the latitude variable name.}

\item{long}{A vector with the longitude variable name.}

\item{h}{The bandwidth parameter.}

\item{data}{A data set object with \code{yvar} and \code{xvar}.}

\item{xglobal}{A vector with descriptive variable(s) name(s) with global effect.}

\item{grid}{A data set with the location variables. Only used when the location variable are in another data set, different from data set used in parameter \code{data}. Variable name \code{"lat"} is expected for latitude and \code{"long"} for longitude.}

\item{method}{The kernel function used. The options are: \code{"fixed_g"}, \code{"fixed_bsq"} or \code{"adaptive_bsq"}. The default is \code{"fixed_g"}.}

\item{link}{The link function used in modeling. The options are: \code{"logit"}, \code{"probit"}, \code{"loglog"} or \code{"cloglog"}. The default is \code{"logit"}.}

\item{distancekm}{Logical. If \code{TRUE} use the distance in kilometers otherwise, use the Euclidean distance. The default is \code{TRUE}.}

\item{global}{Logical. If \code{TRUE} return to global model, giving the results from \code{betareg_gwbr} function. The default is \code{FALSE}.}

\item{maxint}{A maximum number of iterations to numerically maximize the log-likelihood function in search of the parameter estimates. The default is \code{maxint=100}.}
}
\value{
A list that contains:

\itemize{
\item \code{parameter_estimates_qtls} - Parameter estimates quartiles and interquartile range.
\item \code{parameter_estimates_desc} - Parameter estimates mean, minimum and maximum.
\item \code{std_qtls} - Standard deviation quartiles and interquartile range.
\item \code{std_desc} - Standard deviation mean, minimum and maximum.
\item \code{est_n_parameters} - Number of parameters.
\item \code{est_gwr_parameters} - Effective number of parameters in the local model.
\item \code{phi} - Vector of precision parameter estimates.
\item \code{global_parameter} - Global parameter estimates, when existing.
\item \code{global_phi} - Global scale parameter estimate, when existing.
\item \code{global_parameter_tab} - Global parameter estimates table, when existing.
\item \code{residuals} - Table with observed values (\code{y}), estimated values (\code{yhat}), the link function applied in the estimated values (\code{eta}), pure residual (\code{res}), standardized residual (\code{resstd}), standardized weighted residual 2 (\code{resstd2}), residual deviance (\code{resdeviance}), Cooks distance (\code{cookD}), generalized leverage (\code{glbp}) and number of iterations (\code{iteration}).
\item \code{log_likelihood} - Log-likelihood of the fitted model.
\item \code{aicc} - Corrected Akaike information criterion.
\item \code{r2} - Pseudo R2 and adjusted pseudo R2 statistics.
\item \code{bp_test} - Breusch-Pagan test for heteroscedasticity.
\item \code{w} - Matrix of weights.
\item \code{parameters} - Table with parameter estimates of each model.
\item \code{significance} - Significance level of each model.
\item \code{bandwidth} - Bandwidth used.
\item \code{link_function} - The link function used in modeling.
}
}
\description{
Fits a local regression model for each location using the beta distribution, recommended for rates and proportions, using a parametrization with mean (transformed by the link function) and precision parameter (called phi). For more details see Da Silva and Lima (2017).
}
\examples{
\donttest{
data(saopaulo)
output_list=gwbr("prop_landline",c("prop_urb", "prop_poor"),"y","x",116.3647,saopaulo)

## Descriptive statistics of the parameter estimates
output_list$parameter_estimates_desc

## Table with all parameter estimates and your respective statistics
output_list$parameters
}
}
