% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebi_server.R
\name{is_ebi_reachable}
\alias{is_ebi_reachable}
\title{Is the GWAS Catalog REST API server reachable?}
\usage{
is_ebi_reachable(url = "https://www.ebi.ac.uk", port = 443L, chatty = FALSE)
}
\arguments{
\item{url}{NHGRI-EBI GWAS Catalog server URL. Default is
\url{https://www.ebi.ac.uk}. You should not need to change this parameter.}

\item{port}{Network port on which to ping the server. You should not need to
change this parameter.}

\item{chatty}{Whether to be verbose (\code{TRUE}) or not (\code{FALSE}).}
}
\value{
A logical value: \code{TRUE} if EBI server is reachable, \code{FALSE}
  otherwise.
}
\description{
Check if the EBI server where the GWAS Catalog REST API server is running is
reachable. This function attempts to connect to
\href{https://www.ebi.ac.uk}{https://www.ebi.ac.uk}, returning \code{TRUE} on
success, and \code{FALSE} otherwise. Set \code{chatty = TRUE} for a step by
step description of the connection attempt.
}
\examples{
# Check if the GWAS Catalog Server is reachable
is_ebi_reachable() # Returns TRUE or FALSE.

# Check if the GWAS Catalog Server is reachable
# and show exactly at what step is it failing (if that is the case)
is_ebi_reachable(chatty = TRUE)

}
