% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amp_mix_perc.R, R/guescini.R
\name{amp_mix_perc}
\alias{amp_mix_perc}
\title{Amplification mix percentage}
\format{
A \link[tibble:tibble-package]{tibble} with 21,000 rows and 12 variables:
\describe{
\item{\code{plate}}{Plate identifier.}
\item{\code{well}}{Well identifier. Values are always \code{NA} (not available). This
variable is kept nevertheless to be coherent with other data sets from other
similar R data packages.}
\item{\code{dye}}{The type of dye used. In this data set the values are always
\code{"SYBR"}, meaning SYBR Green I master mix (Roche).}
\item{\code{target}}{Target identifier: the amplicon used, \code{"MT_ND1"}.}
\item{\code{sample_type}}{Sample type (all curves are standards, i.e. \code{"std"}).}
\item{\code{run}}{This variable discriminates amplification curves within the
group defined by \code{amp_mix_perc} and \code{copies}. Range: \code{1} thru \code{12}.}
\item{\code{replicate}}{Replicate identifier: 1 thru 3.}
\item{\code{amp_mix_perc}}{Amplification mix percentage.}
\item{\code{copies}}{Standard copy number.}
\item{\code{dilution}}{Dilution factor. Higher number means greater dilution.}
\item{\code{cycle}}{PCR cycle.}
\item{\code{fluor}}{Raw fluorescence values.}
}

A \link[tibble:tibble-package]{tibble} with 21,000 rows and 11 variables:
\describe{
\item{\code{plate}}{Plate identifier.}
\item{\code{well}}{Well identifier. Values are always \code{NA} (not available). This
variable is kept nevertheless to be coherent with other data sets from other
similar R data packages.}
\item{\code{dye}}{The type of dye used. In this data set the values are always
\code{"SYBR"}, meaning SYBR Green I master mix (Roche).}
\item{\code{target}}{Target identifier: the amplicon used, \code{"MT_ND1"}.}
\item{\code{sample_type}}{Sample type (all curves are standards, i.e. \code{"std"}).}
\item{\code{replicate}}{Replicate identifier: 1 thru 3.}
\item{\code{amp_mix_perc}}{Amplification mix percentage.}
\item{\code{copies}}{Standard copy number.}
\item{\code{dilution}}{Dilution factor. Higher number means greater dilution.}
\item{\code{cycle}}{PCR cycle.}
\item{\code{fluor}}{Raw fluorescence values.}
}
}
\source{
\doi{10.1186/1471-2105-9-326}

\doi{10.1186/1471-2105-9-326}
}
\description{
This data set is for a set of quantitative real-time PCR runs that targets
the amplification of a sequence of the MT-ND1 gene, for a seven-point,
ten-fold a serial dilution starting at 3.14 x 10^7 copies of DNA molecules.
In addition, a range of amplification mix quantities ranging from 60\% to 100\%
are also performed. This results in 5 serial dilutions, one for each
amplification mix quantity (0.6, 0.7, 0.8, 0.9 and 1.0).
Please read the Methods section of Guescini et al.
(2008) for more details.

Each data set comprises a seven-point, ten-fold dilution series, repeated in
12 independent runs targeting an amplicon for the MT-ND1 gene. A slight
amplification inhibition in the quantitative real-time PCR experiments was
obtained by using two systems: decreasing the amplification mix
(\code{amp_mix_perc}) used in the reaction and adding varying amounts of IgG, a
known PCR inhibitor. Please read the Methods section of Guescini et al.
(2008) for more details.
}
\examples{
amp_mix_perc

amp_mix_perc

}
\keyword{datasets}
