% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_infunnel}
\alias{gsw_infunnel}
\title{Determine whether a point is inside the 'funnel' of acceptable values}
\usage{
gsw_infunnel(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{CT}{Conservative Temperature [ degC ].}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
a logical value indicating whether the given
point is inside the funnel of acceptable values.
}
\description{
This function determines whether a given hydrographic value lies what
the TEOS-10 literature calls a "funnel" of values that lead to acceptably
accurate computation of specific volume.  For more details, consult the
TEOS-10 literature, perhaps starting with the materials referred to in the
webpage cited in the \sQuote{References} section.
}
\examples{
library(gsw)
gsw_infunnel(35, 10, 100) # TRUE
gsw_infunnel(45, 10, 100) # FALSE: too salty
gsw_infunnel(35, -4, 100) # FALSE: below freezing

}
\references{
\url{https://www.teos-10.org/pubs/gsw/html/gsw_infunnel.html}
}
\seealso{
Other things related to density: 
\code{\link{gsw_CT_from_rho}()},
\code{\link{gsw_CT_maxdensity}()},
\code{\link{gsw_SA_from_rho}()},
\code{\link{gsw_alpha}()},
\code{\link{gsw_alpha_on_beta}()},
\code{\link{gsw_alpha_wrt_t_exact}()},
\code{\link{gsw_alpha_wrt_t_ice}()},
\code{\link{gsw_beta}()},
\code{\link{gsw_beta_const_t_exact}()},
\code{\link{gsw_pot_rho_t_exact}()},
\code{\link{gsw_rho}()},
\code{\link{gsw_rho_alpha_beta}()},
\code{\link{gsw_rho_first_derivatives}()},
\code{\link{gsw_rho_first_derivatives_wrt_enthalpy}()},
\code{\link{gsw_rho_ice}()},
\code{\link{gsw_rho_t_exact}()},
\code{\link{gsw_sigma0}()},
\code{\link{gsw_sigma1}()},
\code{\link{gsw_sigma2}()},
\code{\link{gsw_sigma3}()},
\code{\link{gsw_sigma4}()},
\code{\link{gsw_specvol}()},
\code{\link{gsw_specvol_alpha_beta}()},
\code{\link{gsw_specvol_anom_standard}()},
\code{\link{gsw_specvol_ice}()},
\code{\link{gsw_specvol_t_exact}()}
}
\concept{things related to density}
