% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpoles.R
\name{mpoles}
\alias{mpoles}
\title{Multiplicity of poles}
\usage{
mpoles(p, tol = 0.001, reorder = TRUE, index.return = FALSE)
}
\arguments{
\item{p}{vector of poles.}

\item{tol}{tolerance. If the relative difference of two poles is less than
\code{tol} then they are considered to be multiples. The default value for
\code{tol} is 0.001.}

\item{reorder}{logical. If \code{TRUE}, (default), the output is ordered from
largest pole to smallest pole.}

\item{index.return}{logical indicating if index vector should be returned as
well. See examples. Default: \code{FALSE}.}
}
\value{
If \code{index.return = TRUE}, a list consisting of two vectors:
\describe{
  \item{m}{vector specifying the multiplicity of the poles}
  \item{n}{index}
}
If \code{index.return = FALSE}, only \code{m} is returned (as a vector).
}
\description{
Identify unique poles and their associated multiplicity.
}
\examples{
p <- c(2, 3, 1, 1, 2)
ret <- mpoles(p, index = TRUE)

}
\seealso{
\code{\link{poly}}, \code{\link{residue}}
}
\author{
Ben Abbott, \email{bpabbott@mac.com}.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}
}
