% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spending-spec.R
\name{SpendingSpec}
\alias{SpendingSpec}
\title{SpendingSpec}
\value{
An R6 class generator. Use \verb{$new()} to create a \code{SpendingSpec} object.
}
\description{
SpendingSpec

SpendingSpec
}
\details{
An R6 class representing a single spending function (\code{fun}) and a tuning
specification for its parameter (\code{par}).
}
\examples{
spec <- SpendingSpec$new(gsDesign::sfHSD, par = tune_seq(-4, -2, length_out = 2))
spec$expand()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{fun}}{Spending function (callable with signature \verb{(alpha, t, param)}).}

\item{\code{fun_label}}{Label captured from the constructor call (used for plotting).}

\item{\code{par}}{Tuning specification for the spending parameter.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SpendingSpec-new}{\code{SpendingSpec$new()}}
\item \href{#method-SpendingSpec-expand}{\code{SpendingSpec$expand()}}
\item \href{#method-SpendingSpec-clone}{\code{SpendingSpec$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpendingSpec-new"></a>}}
\if{latex}{\out{\hypertarget{method-SpendingSpec-new}{}}}
\subsection{Method \code{new()}}{
Create a new spending specification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpendingSpec$new(fun, par = tune_fixed(NULL))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{Spending function.}

\item{\code{par}}{Spending parameter specification.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpendingSpec-expand"></a>}}
\if{latex}{\out{\hypertarget{method-SpendingSpec-expand}{}}}
\subsection{Method \code{expand()}}{
Expand to a list of spending settings (fun + concrete parameter values).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpendingSpec$expand()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpendingSpec-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SpendingSpec-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpendingSpec$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
