% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_gpv.R
\name{opt_gpv}
\alias{opt_gpv}
\title{Optimize Generalized Path Value}
\usage{
opt_gpv(sociomatrix, source, target, p = Inf, node_costs = NULL)
}
\arguments{
\item{sociomatrix}{a nonnegative, real valued sociomatrix.}

\item{source}{an integer index corresponding to a node in \code{sociomatrix}}

\item{target}{an integer index corresponding to a node in \code{sociomatrix}}

\item{p}{a nonnegative real number that sets the 'p-norm' parameter for 
generalized path value calculation.}

\item{node_costs}{a list of costs, in order, of all nodes represented in the 
sociomatrix, all are assumed 0 if unspecified}
}
\description{
Identify the path of optimal generalized path value from a source node
to a target node.
}
\seealso{
\code{\link{gpv}} to calculate the value of a user-specified path,
    \code{\link{all_opt_gpv}} to simultaneously identify the optimal paths 
    from any source node to any target node.
}
