% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grangersearch.R
\name{granger_lag_select}
\alias{granger_lag_select}
\title{Lag Selection Analysis for Granger Causality}
\usage{
granger_lag_select(.data, ..., lag = 1:4, alpha = 0.05, test = "F")
}
\arguments{
\item{.data}{A data frame or tibble containing the time series variables.}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Columns to include.
If empty, all numeric columns are used.}

\item{lag}{Integer vector. The lag orders to test. Default is \code{1:4}.}

\item{alpha}{Numeric. Significance level. Default is 0.05.}

\item{test}{Character. Test type. Default is "F".}
}
\value{
A tibble with one row per (cause, effect, lag) combination:
\describe{
\item{cause}{Character. The potential cause variable.}
\item{effect}{Character. The potential effect variable.}
\item{lag}{Integer. The lag order tested.}
\item{statistic}{Numeric. The F-test statistic.}
\item{p.value}{Numeric. The p-value.}
\item{significant}{Logical. Whether significant at alpha.}
}
}
\description{
Analyzes how Granger causality test results change across different lag orders.
Returns detailed results for all lag-pair combinations, useful for optimal
lag selection and visualization.
}
\details{
Unlike \code{\link[=granger_search]{granger_search()}} which returns only the best lag for each pair,
this function returns results for all lag values tested. This is useful for:
\itemize{
\item Visualizing how p-values change with lag order
\item Selecting the optimal lag for each relationship
\item Understanding the temporal dynamics of causality
}
}
\examples{
set.seed(123)
n <- 100
df <- data.frame(
  A = cumsum(rnorm(n)),
  B = cumsum(rnorm(n))
)
df$B <- c(0, 0.7 * df$A[1:(n-1)]) + rnorm(n, sd = 0.5)

# Get results for lags 1 through 5
lag_results <- granger_lag_select(df, lag = 1:5)

# Can be used with ggplot2 for visualization
# library(ggplot2)
# ggplot(lag_results, aes(x = lag, y = p.value, color = paste(cause, "->", effect))) +
#   geom_line() + geom_point() +
#   geom_hline(yintercept = 0.05, linetype = "dashed") +
#   labs(title = "P-values by Lag Order", color = "Direction")

}
\seealso{
\code{\link[=granger_search]{granger_search()}} for getting best results across lags,
\code{\link[=plot.granger_lag_select]{plot.granger_lag_select()}} for built-in visualization.
}
