% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_xy_CatGroup.R
\name{plot_xy_CatGroup}
\alias{plot_xy_CatGroup}
\title{Plot points on a quantitative X - Y plot & a categorical grouping variable.}
\usage{
plot_xy_CatGroup(
  data,
  xcol,
  ycol,
  CatGroup,
  facet,
  Boxplot = FALSE,
  Mean = FALSE,
  ErrorType = "SD",
  symsize = 3,
  s_alpha = 0.8,
  TextXAngle = 0,
  LogYTrans,
  LogXTrans,
  LogYBreaks = waiver(),
  LogXBreaks = waiver(),
  LogYLabels = waiver(),
  LogXLabels = waiver(),
  LogYLimits = NULL,
  LogXLimits = NULL,
  facet_scales = "fixed",
  fontsize = 20,
  bwid = 0.3,
  b_alpha = 0.3,
  l_alpha = 0.8,
  e_alpha = 0.8,
  all_size = 2,
  all_alpha = 0.5,
  symthick,
  bthick,
  ethick,
  ewid = 0.2,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy", "kelly",
    "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColSeq = TRUE,
  ColRev = FALSE,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column (without quotes) with quantitative X variable.}

\item{ycol}{name of the column (without quotes) with quantitative Y variable.}

\item{CatGroup}{a categorical variable as grouping factor for colour of data points, should be a categorical variable for default colours to work. Will be converted to \code{factor} if your column is numeric}

\item{facet}{add another variable (without quotes) from the data table to create faceted graphs using \code{\link[ggplot2]{facet_wrap}}.}

\item{Boxplot}{logical TRUE/FALSE to plot box and whiskers plot (default = FALSE).}

\item{Mean}{logical TRUE/FALSE to plot mean and SD/SEM/CI95 error bars (default = FALSE).}

\item{ErrorType}{select the type of error bars to display. Default is "SD" (standard deviation). Other options are "SEM" (standard error of the mean) and "CI95" (95\% confidence interval based on t distributions).}

\item{symsize}{size of symbols used by \code{\link[ggplot2]{geom_point}}. Default set to 3.}

\item{s_alpha}{fractional opacity of symbols, default set to to 0.8 (i.e, 80\% opacity).}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{LogYTrans}{transform Y axis into "log10" or "log2" (in quotes).}

\item{LogXTrans}{transform X axis into "log10" or "log2"}

\item{LogYBreaks}{argument for \code{ggplot2[scale_y_continuous]} for Y axis breaks on log scales, default is \code{waiver()}, or provide a vector of desired breaks.}

\item{LogXBreaks}{argument for \code{ggplot2[scale_x_continuous]} for Y axis breaks on log scales, default is \code{waiver()}, or provide a vector of desired breaks.}

\item{LogYLabels}{argument for \code{ggplot2[scale_y_continuous]} for Y axis labels on log scales, default is \code{waiver()}, or provide a vector of desired labels.}

\item{LogXLabels}{argument for \code{ggplot2[scale_x_continuous]} for Y axis labels on log scales, default is \code{waiver()}, or provide a vector of desired labels.}

\item{LogYLimits}{a vector of length two specifying the range (minimum and maximum) of the Y axis.}

\item{LogXLimits}{a vector of length two specifying the range (minimum and maximum) of the X axis.}

\item{facet_scales}{whether or not to fix scales on X & Y axes for all graphs. Can be \code{fixed} (default), \code{free}, \code{free_y} or \code{free_x} (for Y and X axis one at a time, respectively).}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{\link[ggplot2]{theme_classic}}, default set to size 20.}

\item{bwid}{width of boxplot (default = 0.3).}

\item{b_alpha}{fractional opacity of boxes, (default = 0.3).}

\item{l_alpha}{fractional opacity of lines joining boxes, (default = 0.8).}

\item{e_alpha}{fractional opacity of error bars, (default = 0.8).}

\item{all_size}{size of symbols of all data points, if shown (default = 2.5).}

\item{all_alpha}{fractional opacity of all data points (default = 0.3). Set to non-zero value if you would like all data points plotted in addition to the mean.}

\item{symthick}{size (in 'pt' units) of outline of symbol lines (\code{stroke}), default = \code{fontsize}/22.}

\item{bthick}{size (in 'pt' units) of outline of boxes, whisker and joining lines (\code{stroke}), default = \code{fontsize}/22.}

\item{ethick}{thickness of error bar lines; default \code{fontsize}/22.}

\item{ewid}{width of error bars, default set to 0.2.}

\item{ColPal}{grafify colour palette to apply (in quotes), default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{...}{any additional arguments to pass on.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a data table, quantitative X and Y variables along with a categorical grouping variable, and a and plots a graph with using \code{\link[ggplot2]{geom_point}}. The categorical \code{CatGroup} variable is mapped to the \code{fill} aesthetic of symbols.
}
\details{
A box and whisker plot with lines joining the medians can be plotted with \code{Boxplot = TRUE}. If only box plot is needed without the line, set the opacity of the line to 0 (i.e., l_alpha = 0).

Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} (logical TRUE/FALSE) decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.

This plot is related to \code{\link{plot_xy_NumGroup}} which requires a numeric grouping factor.
When summary statistics (mean/median) are required, use \code{\link{plot_3d_scatterbar}}, \code{\link{plot_3d_scatterbox}} or \code{\link{plot_4d_scatterbox}}.
}
\examples{
#The grouping factor cyl  is automatically converted to categorical variable
plot_xy_CatGroup(data = mtcars,
xcol = mpg, ycol = disp, CatGroup = cyl, 
ColPal = "vibrant", ColSeq = FALSE)

#with boxplot
plot_xy_CatGroup(data = mpg, 
xcol = cyl, ycol = cty, 
CatGroup = fl, Boxplot = TRUE)

#add another variable
#with boxplot
plot_xy_CatGroup(data = mpg, 
xcol = cyl, ycol = cty, 
CatGroup = fl, facet = drv,
Boxplot = TRUE)

}
