% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_detect_single_grab.R
\name{prob_detect_single_grab}
\alias{prob_detect_single_grab}
\title{Probability of detection in a single grab sample}
\usage{
prob_detect_single_grab(r, p, d)
}
\arguments{
\item{r}{number of primary increments in a grab sample or grab sample size}

\item{p}{limiting fraction or proportion of contaminated increments}

\item{d}{serial correlation of contamination between the primary increments}
}
\value{
Probability of detection in a grab sample
}
\description{
This function calculates the probability of detection in a single grab sample comprising of \code{r} primary increments for given serial correlation \code{d}.
}
\details{
The probability of detection in any of the grab sample is given by \eqn{p_d} as
\deqn{p_d = 1-(1-p)(1-p(1-d))^{r-1}}
}
\examples{
   r <-  25
   p <-  0.005
   d <-  0.99
   prob_detect_single_grab(r, p, d)
}
