% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{Subscription}
\alias{Subscription}
\title{Builds a Subscription Object}
\usage{
Subscription(
  dead_letter_policy = NULL,
  msg_retention_duration = NULL,
  labels = NULL,
  retry_policy = NULL,
  push_config = NULL,
  ack_deadline = NULL,
  expiration_policy = NULL,
  filter = NULL,
  detached = NULL,
  retain_acked_msgs = NULL,
  topic = NULL,
  name = NULL,
  enable_msg_ordering = NULL,
  topic_msg_retention = NULL
)
}
\arguments{
\item{dead_letter_policy}{\code{DeadLetterPolicy} A policy that specifies the conditions for dead
lettering messages in this subscription}

\item{msg_retention_duration}{\code{character} How long to retain unacknowledged messages in
the subscription's backlog, from the moment a message is published}

\item{labels}{\code{list} See Creating and managing labels}

\item{retry_policy}{\code{RetryPolicy} A policy that specifies how Pub/Sub retries message
delivery for this subscription}

\item{push_config}{\code{PushConfig} If push delivery is used with this subscription, this
field is used to configure it}

\item{ack_deadline}{\code{character} The approximate amount of time (on a best-effort basis)
Pub/Sub waits for the subscriber to acknowledge receipt before resending the message}

\item{expiration_policy}{\code{ExpirationPolicy} A policy that specifies the conditions for
this subscription's expiration}

\item{filter}{\code{character} An expression written in the Pub/Sub \href{https://cloud.google.com/pubsub/docs/filtering}{filter language}}

\item{detached}{\code{logical} Indicates whether the subscription is detached from its topic}

\item{retain_acked_msgs}{\code{logical} Indicates whether to retain acknowledged messages}

\item{topic}{\code{character}, \code{Topic} A \code{Topic} object or topic name}

\item{name}{\code{character} A name for the subscription}

\item{enable_msg_ordering}{\code{logical} If true, messages published with the same \code{ordering_key}
in \code{PubsubMessage} will be delivered to the subscribers in the order in which they are
received by the Pub/Sub system}

\item{topic_msg_retention}{\code{character} minimum duration for which a message is retained after
it is published to the subscription's topic}
}
\value{
\code{Subscription} object
}
\description{
Builds a Subscription Object
}
\seealso{
Other Object functions: 
\code{\link{DeadLetterPolicy}()},
\code{\link{DlqPolicy}()},
\code{\link{ExpirationPolicy}()},
\code{\link{MessageStoragePolicy}()},
\code{\link{PubsubMessage}()},
\code{\link{PushConfig}()},
\code{\link{RetryPolicy}()},
\code{\link{SchemaSettings}()},
\code{\link{Schema}()},
\code{\link{Snapshot}()},
\code{\link{Topic}()}
}
\concept{Object functions}
