% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{boot.joint}
\alias{boot.joint}
\title{Bootstrapping a \code{joint} object}
\usage{
boot.joint(
  fit,
  data,
  boot.size = NULL,
  nboot = 100L,
  replace = TRUE,
  progress = TRUE,
  use.MLEs = TRUE,
  control = list()
)
}
\arguments{
\item{fit}{a joint model fit by the \code{\link{joint}} function.}

\item{data}{the original data used to fit the above joint model.}

\item{boot.size}{integer, specifies the number of subjects to resample in the bootstrapping
approach. The default value is \code{boot.size = NULL} which defaults to the number of unique
subjects in the \code{joint} object.}

\item{nboot}{integer, specifies the number of bootstrap samples, default value is 
\code{nboot = 100L}.}

\item{replace}{logical, should sampling be done with replacement? Defaults to 
\code{replace = TRUE}.}

\item{progress}{logical, should a text progress bar showing overall progress be shown
and updated after each successful bootstrapped model fit? Defaults to \code{progress=TRUE}.}

\item{use.MLEs}{logical, should the MLEs of the \code{fit} be used as initial conditions in 
each of the bootstrapped calls to \code{joint}? Defaults to \code{use.MLEs=TRUE} which
should help reduce the computational burden in fitting these bootstrap replicate \code{joint}
objects.}

\item{control}{a list of control arguments, with same possible arguments as shown in 
\code{\link{joint}}. Note that by default the \emph{same} \code{control} arguments used in the
\code{joint} \code{fit} parameter are carried forwards, besides the items \code{return.dmats},
\code{post.process}, and \code{verbose} which are all set to \code{FALSE} in \code{boot.joint}
in order to reduce memory overheads and computation time. Instead, the user
could lessen computational burden of this intensive bootstrapping by changing convergence 
criteria items e.g. \code{conv}, \code{tol.rel}, \code{tol.abs}, \code{tol.thr} in order to 
speed-up convergence of the \code{nboot} individual bootstrapped model fits.}
}
\value{
A list of class \code{boot.joint} which contains the MLEs from supplied \code{joint}
object, as well as the bootstrapped summaries and some model/computation information.
}
\description{
Use an existing model fit by \code{joint} along with the data object originally
used and obtain a mean estimate, standard errors and 95\% confidence interval using the
bootstrap. The original data is resampled by subject, not by observation.
}
\examples{
\donttest{
# Bivariate fit on PBC data -----------------------------------------
data(PBC)

# Subset data and remove NAs
PBC <- subset(PBC, select = c('id', 'survtime', 'status', 'drug', 'time',
                              'albumin', 'platelets'))
PBC <- na.omit(PBC) 

# Specify bivariate fit
long.formulas <- list(
  albumin ~ time*drug + (1 + time|id),
  platelets ~ time * drug + (1 + time|id)
)
surv.formula <- Surv(survtime, status) ~ drug

fit <- joint(long.formulas, surv.formula, PBC, family = list('gaussian', 'poisson'))
# Set 50 bootstraps, with lower absolute tolerance and convergence of 'either'.
BOOT <- boot.joint(fit, PBC, nboot = 50L, control = list(tol.abs = 5e-3, conv = 'either'),
                   use.MLEs = TRUE)
BOOT # Print to console via S3 method
}
}
\seealso{
\code{\link{joint}} \code{\link{vcov.joint}}
}
\author{
James Murray (\email{j.murray7@ncl.ac.uk}).
}
