% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure-level.R
\name{reduce_structure_level}
\alias{reduce_structure_level}
\title{Reduce a Glycan Structure to a Lower Resolution Level}
\usage{
reduce_structure_level(x, to_level)
}
\arguments{
\item{x}{A \code{\link[=glycan_structure]{glycan_structure()}} vector.}

\item{to_level}{The resolution level to reduce to. Can be "basic" or "topological".
Must be a lower resolution level than any structure in \code{x}
("intact" > "partial" > "topological" > "basic").
If \code{to_level} is the same as some structure in \code{x}, the result will be the same as the input.
You can use \code{\link[=get_structure_level]{get_structure_level()}} to check the structure levels of \code{x}.}
}
\value{
A \code{\link[=glycan_structure]{glycan_structure()}} vector reduced to the given resolution level.
}
\description{
This function reduces a glycan structure from a higher resolution level to a lower resolution level
(see \code{\link[=get_structure_level]{get_structure_level()}} for four possible levels of resolution).
For example, it can reduce an "intact" structure to a "topological" structure,
or a "partial" structure to a "basic" structure.
One exception is that you can never reduce an "intact" structure to "partial" level,
because the "partial" level is not deterministic.
}
\details{
The logic is as follows:
\itemize{
\item If \code{to_level} is "topological", this function calls \code{\link[=remove_linkages]{remove_linkages()}} to remove all linkages.
\item If \code{to_level} is "basic", this function calls \code{\link[=remove_linkages]{remove_linkages()}} to remove all linkages,
and \code{\link[=convert_to_generic]{convert_to_generic()}} to convert all monosaccharides to generic.
}
}
\examples{
glycan <- as_glycan_structure("Gal(b1-3)GalNAc(a1-")
reduce_structure_level(glycan, to_level = "topological")

}
\seealso{
\code{\link[=get_structure_level]{get_structure_level()}}
}
