% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logRegMAR.R
\name{logRegMAR}
\alias{logRegMAR}
\title{Fitting binary regression with missing categorical covariates using new likelihood based method}
\usage{
logRegMAR(formula, data, conflev = 0.95, correctn = TRUE, verbose = TRUE)
}
\arguments{
\item{formula}{A formula expression as for regression models, of the form \code{response ~ predictors}. The response should be a numeric binary variable with missing values, and predictors can be any variables. A predictor with categorical values with missing can be used in the model. See the documentation of formula for other details.}

\item{data}{Input data for fitting the model}

\item{conflev}{Confidence level, the default is 0.95}

\item{correctn}{a TRUE or FALSE value, by default it is TRUE.}

\item{verbose}{a TRUE or FALSE value, default is verbose = TRUE}
}
\value{
return the logistic regression estimates
}
\description{
This function allows users to fit logistic regression models with incomplete predictors that are categorical. The model is fitted using a new likelihood-based method, which ensures reliable parameter estimation even when dealing with missing data. For more information on the underlying methodology, please refer to Pradhan, Nychka, and Bandyopadhyay (2024).
}
\examples{
\donttest{
# -----------------Example 1: Metastatic Melanoma --------------------------

est1 <- logRegMAR (failcens ~ size+type+nodal+age+sex+trt,
                   data = metastmelanoma, conflev = 0.95, correctn = FALSE)

est1
# -----------------Bias reduced estimates due to Firth (1993) --------------
est2 <- logRegMAR (failcens ~ size+type+nodal+age+sex+trt,
                   data = metastmelanoma, conflev = 0.95, correctn = TRUE)

est2
# -----------------Bias reduced estimates due to Firth (1993) --------------
est2 <- logRegMAR (CaseCntrl ~ Numnill+Numsleep+Smoke+Set+Reftime,
                   data=meningitis, conflev = 0.95, correctn = TRUE)
est2
}
}
\references{
Firth, D. (1993). Bias reduction of maximum likelihood estimates, Biometrika, 80, 27-38. doi:10.2307/2336755.

Kosmidis, I., Firth, D. (2021). Jeffreys-prior penalty, finiteness and shrinkage in binomial-response generalized linear models. Biometrika, 108, 71-82. doi:10.1093/biomet/asaa052.

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Bridging Gaps in Logistic Regression: Tackling Missing Categorical Covariates with a New Likelihood Method (to be submitted).

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). glmFitMiss: Binary Regression with Missing Data in R (to be submitted)
}
