% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendline_sum.R
\name{trendline_sum}
\alias{trendline_sum}
\title{Summarized Results of Each Regression Model}
\usage{
trendline_sum(
  x,
  y,
  model = "line2P",
  Pvalue.corrected = TRUE,
  summary = TRUE,
  eDigit = 5
)
}
\arguments{
\item{x, y}{the x and y arguments provide the x and y coordinates for the 'ggplot'. Any reasonable way of defining the coordinates is acceptable.}

\item{model}{select which model to fit. Default is "line2P". The "model" should be one of c("line2P", "line3P", "log2P", "exp2P", "exp3P", "power2P", "power3P"), their formulas are as follows:\cr "line2P": y=a*x+b \cr "line3P": y=a*x^2+b*x+c \cr "log2P": y=a*ln(x)+b \cr "exp2P": y=a*exp(b*x) \cr "exp3P": y=a*exp(b*x)+c \cr "power2P": y=a*x^b \cr "power3P": y=a*x^b+c}

\item{Pvalue.corrected}{if P-value corrected or not, the value is one of c("TRUE", "FALSE").}

\item{summary}{summarizing the model fits. Default is TRUE.}

\item{eDigit}{the numbers of digits for summarized results. Default is 3.}
}
\value{
R^2, indicates the R-Squared value of each regression model.

p, indicates the p-value of each regression model.

N, indicates the sample size.

AIC, AICc, or BIC, indicate the Akaike's Information Criterion (AIC), the second-order AIC (AICc) for small samples, or Bayesian Information Criterion (BIC) for fitted model. Click \code{\link[stats]{AIC}} for details. The smaller the AIC, AICc or BIC, the better the model.

RSS, indicate the value of "Residual Sum of Squares".
}
\description{
Summarizing the results of linear or nonlinear regression model which built in the 'ggtrendline()' function. The function includes the following models:\cr
"line2P" (formula as: y=a*x+b), \cr  "line3P" (y=a*x^2+b*x+c), \cr "log2P" (y=a*ln(x)+b), \cr "exp2P" (y=a*exp(b*x)), \cr  "exp3P" (y=a*exp(b*x)+c), \cr "power2P" (y=a*x^b), \cr and "power3P" (y=a*x^b+c).
}
\details{
The linear models (line2P, line3P, log2P) in this package are estimated by \code{\link[stats]{lm}} function, \cr while the nonlinear models (exp2P, exp3P, power2P, power3P) are estimated by \code{\link[stats]{nls}} function (i.e., least-squares method).\cr\cr The argument 'Pvalue.corrected' is workful for non-linear regression only.\cr\cr If "Pvalue.corrected = TRUE", the P-vlaue is calculated by using "Residual Sum of Squares" and "Corrected Total Sum of Squares (i.e. sum((y-mean(y))^2))".\cr\cr If "Pvalue.corrected = TRUE", the P-vlaue is calculated by using "Residual Sum of Squares" and "Uncorrected Total Sum of Squares (i.e. sum(y^2))".
}
\note{
If the output of 'AICc' is 'Inf', not an exact number, please try to expand the sample size of your dataset to >=6.
}
\examples{
library(ggtrendline)
x <- c(1, 3, 6, 9,  13,   17)
y <- c(5, 8, 11, 13, 13.2, 13.5)

trendline_sum(x, y, model="exp3P", summary=TRUE, eDigit=3)

}
\seealso{
\code{\link{ggtrendline}}, \code{\link{SSexp2P}}, \code{\link{SSexp3P}}, \code{\link{SSpower2P}}, \code{\link{SSpower3P}}, \code{\link[stats]{nls}}, \code{\link[stats]{selfStart}}, \code{\link[AICcmodavg]{AICc}}
}
