% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_okabe_ito}
\alias{scale_okabe_ito}
\alias{scale_colour_okabe_ito}
\alias{scale_color_okabe_ito}
\alias{scale_fill_okabe_ito}
\alias{scale_edge_colour_okabe_ito}
\alias{scale_edge_color_okabe_ito}
\title{Okabe-Ito Scales for ggplot2 and ggraph}
\usage{
scale_okabe_ito(aesthetics, order = 1:9, alpha = 1, ...)

scale_colour_okabe_ito(aesthetics = "colour", order = 1:9, alpha = NULL, ...)

scale_color_okabe_ito(aesthetics = "colour", order = 1:9, alpha = NULL, ...)

scale_fill_okabe_ito(aesthetics = "fill", order = 1:9, alpha = NULL, ...)

scale_edge_colour_okabe_ito(
  aesthetics = "edge_colour",
  order = 1:9,
  alpha = NULL,
  ...
)

scale_edge_color_okabe_ito(
  aesthetics = "edge_colour",
  order = 1:9,
  alpha = NULL,
  ...
)
}
\arguments{
\item{aesthetics}{The names of the aesthetics that this scale works with.}

\item{order}{A numeric vector, the order of the colors}

\item{alpha}{an alpha-transparency level in the range [0,1]
    (0 means transparent and 1 means opaque).}

\item{...}{Additonal arguments passed to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}}
}
\value{
A ggplot or ggraph scale
}
\description{
Discrete scales for the colorblind-friendly Okabe-Ito palette, including
\code{color}, \code{fill}, and \code{edge_colour}. See \link{palette_okabe_ito} for
details.
}
\examples{
library(ggplot2)

ggplot(mpg, aes(cty, hwy, color = class)) +
  geom_point() +
  scale_color_okabe_ito()

ggplot(mpg, aes(cty, hwy, color = factor(cyl))) +
  geom_point(alpha = 0.7) +
  scale_color_okabe_ito(name = "Cylinders", alpha = .9)

ggplot(mpg, aes(hwy, color = class, fill = class)) +
  geom_density() +
  scale_fill_okabe_ito(name = "Class", alpha = .9) +
  scale_color_okabe_ito(name = "Class")
}
