% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SupplementaryFunctions.R
\name{get_edges}
\alias{get_edges}
\title{Extract an adjacency matrix from a larger data frame}
\usage{
get_edges(df, generation = NA)
}
\arguments{
\item{df}{Dataframe inclduing column names "Identity", "Parent", and either "Generation" or "Time"}

\item{generation}{Numeric value of Generation (or Time) at which to determine the adjacency matrix (defaults to final time point)}
}
\value{
A dataframe comprising the adjacency matrix.
}
\description{
Extract an adjacency matrix from a larger data frame
}
\examples{
\dontrun{
edges <- get_edges(example_df)

# extract the adjacency matrix from the data frame:
pop_df <- get_population_df(example_df)

# create data frame for plot:
Muller_df <- get_Muller_df(edges, pop_df)

require(RColorBrewer) # for the palette

# draw plot:
num_cols <- length(unique(Muller_df$RelativeFitness)) + 1
Muller_df$RelativeFitness <- as.factor(Muller_df$RelativeFitness)
Muller_plot(Muller_df, colour_by = "RelativeFitness", 
            palette = rev(colorRampPalette(brewer.pal(9, "YlOrRd"))(num_cols)), 
            add_legend = TRUE)
}

}
\seealso{
\code{\link{get_population_df}}
}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
