% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-debug.R
\name{stat_debug_group}
\alias{stat_debug_group}
\alias{stat_debug_panel}
\title{Print to console data received by statistics as input}
\usage{
stat_debug_group(
  mapping = NULL,
  data = NULL,
  geom = "null",
  fun.data = "I",
  fun.data.args = list(),
  dbgfun.data = "head",
  dbgfun.data.args = list(),
  geom.dbgfun.data = "head",
  geom.dbgfun.data.args = list(),
  geom.dbgfun.params = NULL,
  geom.dbgfun.params.args = list(),
  dbgfun.print = "print",
  dbgfun.print.args = list(),
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)

stat_debug_panel(
  mapping = NULL,
  data = NULL,
  geom = "null",
  fun.data = "I",
  fun.data.args = list(),
  dbgfun.data = "head",
  dbgfun.data.args = list(),
  geom.dbgfun.data = "head",
  geom.dbgfun.data.args = list(),
  geom.dbgfun.params = NULL,
  geom.dbgfun.params.args = list(),
  dbgfun.print = "print",
  dbgfun.print.args = list(),
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{fun.data}{A function taking a data frame as its first argument and
returning a data frame. This function does the computations generating
the value passed from the statistic to the downstream geometry.}

\item{fun.data.args}{A named list of additional arguments to be passed to
\code{fun.data}.}

\item{dbgfun.data, geom.dbgfun.data, geom.dbgfun.params}{A
functions used to summarise the \code{data} and \code{parameters} objects
received as input by the statistic and geometry.}

\item{dbgfun.data.args, geom.dbgfun.data.args, geom.dbgfun.params.args}{A named list of arguments.}

\item{dbgfun.print}{A function used to print the summary of the \code{data}
object received as input by the statistic, also visible to the geometry,
and used by \code{geom_debug()}.}

\item{dbgfun.print.args}{A named list. Currently ignored!}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\value{
A copy of its \code{data} input, which is an object of class
   \code{"data.frame"} or inheriting from \code{"data.frame"}.
}
\description{
\code{stat_debug_group} and \code{stat_debug_panel}
apply a function to \code{data} and, most importantly,
  echo to the R console their \code{data} input or a summary of it.
}
\details{
These stats are meant to be used for the side-effect of printing to
  the console the \code{data} object received as input by the
  \code{compute_group()} or \code{compute_panel()} function, or a summary of
  it. These \code{data} objects are the same as those received as input by
  any other statistics passed the same arguments. By default, the applied
  function is \code{I()}, the identity function.

  In principle any geom can be passed as argument to override \code{geom =
  "null"}. However, \code{geom = "debug_panel"} and \code{geom =
  "debug_group"} are treated as special cases and functions
  \code{geom.dbgfun.data} and \code{geom.dbgfun.params}, and lists
  \code{geom.dbgfun.data.args} and \code{geom.dbgfun.params.args} renamed and
  passed to the geometry. Arguments passed to these four formal parameters
  are not passed to other geometries.

  Keep in mind that this stat sets default mappings only for the \emph{x}
  and/or \emph{y} aesthetics, additional mappings can be set using
  \code{aes()}, possibly together with \code{after_stat()}.
}
\section{Computed variables}{
 \describe{ \item{x}{x at centre of range}
  \item{y}{y at centre of range} \item{nrow}{\code{nrow()} of \code{data}
  object} \item{ncol}{\code{ncol()} of \code{data} object}
  \item{colnames}{\code{colnames()} of \code{data} object}
  \item{colclasses}{\code{class()} of \code{x} and \code{y} columns in
  \code{data} object} \item{group}{all distinct values in group as passed in
  \code{data} object} \item{PANEL}{all distinct values in PANEL as passed in
  \code{data} object} }
}

\examples{
my.df <- data.frame(x = rep(1:10, 2),
                    y = rep(c(1,2), c(10,10)) + rnorm(20),
                    group = rep(c("A","B"), c(10,10)))

# by default head() is used to show the top rows of the data object
# and geom_null() to silence the data returned by the stat
ggplot(my.df, aes(x,y)) +
  geom_point() +
  stat_debug_group()

# geom_debug prints the data returned by the stat
ggplot(my.df, aes(x,y)) +
  geom_point() +
  stat_debug_group(geom = "debug_panel")

# geom_debug prints the data returned by the stat
ggplot(my.df, aes(x,y)) +
  geom_point() +
  stat_debug_group(geom = "debug_panel",
                   geom.dbgfun.params = "summary")

# to print only the the data returned by the stat
# we pass as summary function a function that always returns NULL
ggplot(my.df, aes(x,y)) +
  geom_point() +
  stat_debug_group(geom = "debug_panel",
                   dbgfun.data = function(x) {NULL})

ggplot(my.df, aes(x,y)) +
  geom_point() +
  stat_debug_group(aes(label = paste("group:", group)),
                   geom = "text")

# here we show all the data object
ggplot(my.df, aes(x,y)) +
  geom_point() +
  stat_debug_group(dbgfun.data = "I")

# with grouping
ggplot(my.df, aes(x,y, colour = group)) +
  geom_point() +
  stat_debug_group()

ggplot(my.df, aes(x,y, colour = group)) +
  geom_point() +
  stat_debug_panel()

ggplot(my.df, aes(x, y, colour = group)) +
  geom_point() +
  stat_debug_group(dbgfun.data = "nrow")

ggplot(my.df, aes(x, y)) +
  geom_point() +
  facet_wrap(~group) +
  stat_debug_group()

# by default head() is used to show the top rows of data object
ggplot(my.df, aes(group,y)) +
  geom_point() +
  stat_debug_group()

ggplot(my.df, aes(group,y)) +
  geom_point() +
  stat_debug_group(dbgfun.data.args = list(n = 3))

}
\concept{diagnosis functions}
