% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_split.R
\name{strip_split}
\alias{strip_split}
\title{Split strips}
\usage{
strip_split(
  position = c("top", "left"),
  clip = "inherit",
  size = "constant",
  bleed = FALSE,
  text_x = NULL,
  text_y = NULL,
  background_x = NULL,
  background_y = NULL,
  by_layer_x = FALSE,
  by_layer_y = FALSE
)
}
\arguments{
\item{position}{A \code{character} vector stating where the strips of faceting
variables should be placed. Can be some of the following: \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}. The length of the \code{position} argument
must match the length of variables provided to the \code{facets} argument in
wrap/manual layouts, or those provided to the \code{rows} and \code{cols} arguments
in the grid layout.}

\item{clip}{A \code{character(1)} that controls whether text labels are clipped to
the background boxes. Can be either \code{"inherit"} (default), \code{"on"} or
\code{"off"}.}

\item{size}{A \code{character(1)} stating that the strip margins in different
layers remain \code{"constant"} or are \code{"variable"}.}

\item{bleed}{A \code{logical(1)} indicating whether merging of lower-layer
variables is allowed when the higher-layer variables are separate. See
the details of \code{\link{strip_nested}} for more info. Note that currently,
\code{strip_split()} cannot recognise collisions between strips, so changing
to \code{bleed = TRUE} can have unexpected results.}

\item{text_x, text_y}{A \code{list()} with
\code{\link[ggplot2:element]{element_text()}} elements. See the details
section in \code{\link[=strip_themed]{strip_themed()}}.}

\item{background_x, background_y}{A \code{list()} with
\code{\link[ggplot2:element]{element_rect()}} elements. See the details
section in \code{\link[=strip_themed]{strip_themed()}}.}

\item{by_layer_x, by_layer_y}{A \code{logical(1)} that when \code{TRUE}, maps the
different elements to different layers of the strip. When \code{FALSE}, maps the
different elements to individual strips, possibly repeating the elements to
match the number of strips through \code{rep_len()}.}
}
\value{
A \code{StripSplit} ggproto object that can be given as an argument to
facets in ggh4x.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This strip style allows a greater control over where a strip is placed
relative to the panel. Different facetting variables are allowed to be
placed on different sides.
}
\details{
Using this style of strip completely overrules the \code{strip.position}
and \code{switch} arguments.
}
\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point()

# --- Wrap examples ------

# Defaults to 1st (cyl) at top, 2nd (drv) on left
p + facet_wrap2(vars(cyl, drv), strip = strip_split())

# Change cyl to left, drv to bottom
p + facet_wrap2(vars(cyl, drv), strip = strip_split(c("left", "bottom")))

# --- Grid examples -----

# Display both strips levels on the left
p + facet_grid2(vars(drv), vars(cyl),
                strip = strip_split(c("left", "left")))

# Separate the strips again
p + facet_grid2(vars(cyl, year),
                strip = strip_split(c("bottom", "left")))

# Using a dummy variable as a title strip
p + facet_grid2(vars(cyl, "year", year),
                strip = strip_split(c("bottom", "left", "left")))
}
\seealso{
Other strips: 
\code{\link{strip_nested}()},
\code{\link{strip_tag}()},
\code{\link{strip_themed}()},
\code{\link{strip_vanilla}()}
}
\concept{strips}
