% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheme-theme.R
\name{scheme_theme}
\alias{scheme_theme}
\title{Plot default theme}
\usage{
scheme_theme(
  ...,
  line,
  rect,
  text,
  title,
  point,
  polygon,
  geom,
  spacing,
  margins,
  aspect.ratio,
  axis.title,
  axis.title.x,
  axis.title.x.top,
  axis.title.x.bottom,
  axis.title.y,
  axis.title.y.left,
  axis.title.y.right,
  axis.text,
  axis.text.x,
  axis.text.x.top,
  axis.text.x.bottom,
  axis.text.y,
  axis.text.y.left,
  axis.text.y.right,
  axis.text.theta,
  axis.text.r,
  axis.ticks,
  axis.ticks.x,
  axis.ticks.x.top,
  axis.ticks.x.bottom,
  axis.ticks.y,
  axis.ticks.y.left,
  axis.ticks.y.right,
  axis.ticks.theta,
  axis.ticks.r,
  axis.minor.ticks.x.top,
  axis.minor.ticks.x.bottom,
  axis.minor.ticks.y.left,
  axis.minor.ticks.y.right,
  axis.minor.ticks.theta,
  axis.minor.ticks.r,
  axis.ticks.length,
  axis.ticks.length.x,
  axis.ticks.length.x.top,
  axis.ticks.length.x.bottom,
  axis.ticks.length.y,
  axis.ticks.length.y.left,
  axis.ticks.length.y.right,
  axis.ticks.length.theta,
  axis.ticks.length.r,
  axis.minor.ticks.length,
  axis.minor.ticks.length.x,
  axis.minor.ticks.length.x.top,
  axis.minor.ticks.length.x.bottom,
  axis.minor.ticks.length.y,
  axis.minor.ticks.length.y.left,
  axis.minor.ticks.length.y.right,
  axis.minor.ticks.length.theta,
  axis.minor.ticks.length.r,
  axis.line,
  axis.line.x,
  axis.line.x.top,
  axis.line.x.bottom,
  axis.line.y,
  axis.line.y.left,
  axis.line.y.right,
  axis.line.theta,
  axis.line.r,
  legend.background,
  legend.margin,
  legend.spacing,
  legend.spacing.x,
  legend.spacing.y,
  legend.key,
  legend.key.size,
  legend.key.height,
  legend.key.width,
  legend.key.spacing,
  legend.key.spacing.x,
  legend.key.spacing.y,
  legend.key.justification,
  legend.frame,
  legend.ticks,
  legend.ticks.length,
  legend.axis.line,
  legend.text,
  legend.text.position,
  legend.title,
  legend.title.position,
  legend.position,
  legend.position.inside,
  legend.direction,
  legend.byrow,
  legend.justification,
  legend.justification.top,
  legend.justification.bottom,
  legend.justification.left,
  legend.justification.right,
  legend.justification.inside,
  legend.location,
  legend.box,
  legend.box.just,
  legend.box.margin,
  legend.box.background,
  legend.box.spacing,
  panel.background,
  panel.border,
  panel.spacing,
  panel.spacing.x,
  panel.spacing.y,
  panel.grid,
  panel.grid.major,
  panel.grid.minor,
  panel.grid.major.x,
  panel.grid.major.y,
  panel.grid.minor.x,
  panel.grid.minor.y,
  panel.ontop,
  panel.widths,
  panel.heights,
  plot.background,
  plot.title,
  plot.title.position,
  plot.subtitle,
  plot.caption,
  plot.caption.position,
  plot.tag,
  plot.tag.position,
  plot.tag.location,
  plot.margin,
  strip.background,
  strip.background.x,
  strip.background.y,
  strip.clip,
  strip.placement,
  strip.text,
  strip.text.x,
  strip.text.x.bottom,
  strip.text.x.top,
  strip.text.y,
  strip.text.y.left,
  strip.text.y.right,
  strip.switch.pad.grid,
  strip.switch.pad.wrap,
  complete = FALSE,
  validate = TRUE
)
}
\arguments{
\item{...}{A \code{\link[ggplot2:theme]{theme()}} object or additional element
specifications not part of base ggplot2. In general, these should also be
defined in the \verb{element tree} argument. \code{\link[rlang:splice]{Splicing}} a list
is also supported.}

\item{line}{all line elements (\code{\link[ggplot2:element_line]{element_line()}})}

\item{rect}{all rectangular elements (\code{\link[ggplot2:element_rect]{element_rect()}})}

\item{text}{all text elements (\code{\link[ggplot2:element_text]{element_text()}})}

\item{title}{all title elements: plot, axes, legends (\code{\link[ggplot2:element_text]{element_text()}};
inherits from \code{text})}

\item{point}{all point elements (\code{\link[ggplot2:element_point]{element_point()}})}

\item{polygon}{all polygon elements (\code{\link[ggplot2:element_polygon]{element_polygon()}})}

\item{geom}{defaults for geoms (\code{\link[ggplot2:element_geom]{element_geom()}})}

\item{spacing}{all spacings (\code{\link[grid:unit]{unit()}})}

\item{margins}{all margins (\code{\link[ggplot2:margin]{margin()}})}

\item{aspect.ratio}{aspect ratio of the panel}

\item{axis.title, axis.title.x, axis.title.y, axis.title.x.top, axis.title.x.bottom, axis.title.y.left, axis.title.y.right}{labels of axes (\code{\link[ggplot2:element_text]{element_text()}}). Specify all axes' labels (\code{axis.title}),
labels by plane (using \code{axis.title.x} or \code{axis.title.y}), or individually
for each axis (using \code{axis.title.x.bottom}, \code{axis.title.x.top},
\code{axis.title.y.left}, \code{axis.title.y.right}). \verb{axis.title.*.*} inherits from
\verb{axis.title.*} which inherits from \code{axis.title}, which in turn inherits
from \code{text}}

\item{axis.text, axis.text.x, axis.text.y, axis.text.x.top, axis.text.x.bottom, axis.text.y.left, axis.text.y.right, axis.text.theta, axis.text.r}{tick labels along axes (\code{\link[ggplot2:element_text]{element_text()}}). Specify all axis tick labels (\code{axis.text}),
tick labels by plane (using \code{axis.text.x} or \code{axis.text.y}), or individually
for each axis (using \code{axis.text.x.bottom}, \code{axis.text.x.top},
\code{axis.text.y.left}, \code{axis.text.y.right}). \verb{axis.text.*.*} inherits from
\verb{axis.text.*} which inherits from \code{axis.text}, which in turn inherits
from \code{text}}

\item{axis.ticks, axis.ticks.x, axis.ticks.x.top, axis.ticks.x.bottom, axis.ticks.y, axis.ticks.y.left, axis.ticks.y.right, axis.ticks.theta, axis.ticks.r}{tick marks along axes (\code{\link[ggplot2:element_line]{element_line()}}). Specify all tick marks (\code{axis.ticks}),
ticks by plane (using \code{axis.ticks.x} or \code{axis.ticks.y}), or individually
for each axis (using \code{axis.ticks.x.bottom}, \code{axis.ticks.x.top},
\code{axis.ticks.y.left}, \code{axis.ticks.y.right}). \verb{axis.ticks.*.*} inherits from
\verb{axis.ticks.*} which inherits from \code{axis.ticks}, which in turn inherits
from \code{line}}

\item{axis.minor.ticks.x.top, axis.minor.ticks.x.bottom, axis.minor.ticks.y.left, axis.minor.ticks.y.right, axis.minor.ticks.theta, axis.minor.ticks.r}{minor tick marks along axes (\code{\link[ggplot2:element_line]{element_line()}}). \verb{axis.minor.ticks.*.*}
inherit from the corresponding major ticks \verb{axis.ticks.*.*}.}

\item{axis.ticks.length, axis.ticks.length.x, axis.ticks.length.x.top, axis.ticks.length.x.bottom, axis.ticks.length.y, axis.ticks.length.y.left, axis.ticks.length.y.right, axis.ticks.length.theta, axis.ticks.length.r}{length of tick marks (\code{unit}). \code{axis.ticks.length} inherits from \code{spacing}.}

\item{axis.minor.ticks.length, axis.minor.ticks.length.x, axis.minor.ticks.length.x.top, axis.minor.ticks.length.x.bottom, axis.minor.ticks.length.y, axis.minor.ticks.length.y.left, axis.minor.ticks.length.y.right, axis.minor.ticks.length.theta, axis.minor.ticks.length.r}{length of minor tick marks (\code{unit}), or relative to \code{axis.ticks.length} when provided with \code{rel()}.}

\item{axis.line, axis.line.x, axis.line.x.top, axis.line.x.bottom, axis.line.y, axis.line.y.left, axis.line.y.right, axis.line.theta, axis.line.r}{lines along axes (\code{\link[ggplot2:element_line]{element_line()}}). Specify lines along all axes (\code{axis.line}),
lines for each plane (using \code{axis.line.x} or \code{axis.line.y}), or individually
for each axis (using \code{axis.line.x.bottom}, \code{axis.line.x.top},
\code{axis.line.y.left}, \code{axis.line.y.right}). \verb{axis.line.*.*} inherits from
\verb{axis.line.*} which inherits from \code{axis.line}, which in turn inherits
from \code{line}}

\item{legend.background}{background of legend (\code{\link[ggplot2:element_rect]{element_rect()}}; inherits
from \code{rect})}

\item{legend.margin}{the margin around each legend (\code{\link[ggplot2:margin]{margin()}}); inherits
from \code{margins}.}

\item{legend.spacing, legend.spacing.x, legend.spacing.y}{the spacing between legends (\code{unit}). \code{legend.spacing.x} & \code{legend.spacing.y}
inherit from \code{legend.spacing} or can be specified separately.
\code{legend.spacing} inherits from \code{spacing}.}

\item{legend.key}{background underneath legend keys (\code{\link[ggplot2:element_rect]{element_rect()}};
inherits from \code{rect})}

\item{legend.key.size, legend.key.height, legend.key.width}{size of legend keys (\code{unit}); key background height & width inherit from
\code{legend.key.size} or can be specified separately. In turn \code{legend.key.size}
inherits from \code{spacing}.}

\item{legend.key.spacing, legend.key.spacing.x, legend.key.spacing.y}{spacing
between legend keys given as a \code{unit}. Spacing in the horizontal (x) and
vertical (y) direction inherit from \code{legend.key.spacing} or can be
specified separately. \code{legend.key.spacing} inherits from \code{spacing}.}

\item{legend.key.justification}{Justification for positioning legend keys
when more space is available than needed for display. The default, \code{NULL},
stretches keys into the available space. Can be a location like \code{"center"}
or \code{"top"}, or a two-element numeric vector.}

\item{legend.frame}{frame drawn around the bar (\code{\link[ggplot2:element_rect]{element_rect()}}).}

\item{legend.ticks}{tick marks shown along bars or axes (\code{\link[ggplot2:element_line]{element_line()}})}

\item{legend.ticks.length}{length of tick marks in legend
(\code{\link[grid:unit]{unit()}}); inherits from \code{legend.key.size}.}

\item{legend.axis.line}{lines along axes in legends (\code{\link[ggplot2:element_line]{element_line()}})}

\item{legend.text}{legend item labels (\code{\link[ggplot2:element_text]{element_text()}}; inherits from
\code{text})}

\item{legend.text.position}{placement of legend text relative to legend keys
or bars ("top", "right", "bottom" or "left"). The legend text placement
might be incompatible with the legend's direction for some guides.}

\item{legend.title}{title of legend (\code{\link[ggplot2:element_text]{element_text()}}; inherits from
\code{title})}

\item{legend.title.position}{placement of legend title relative to the main
legend ("top", "right", "bottom" or "left").}

\item{legend.position}{the default position of legends ("none", "left",
"right", "bottom", "top", "inside")}

\item{legend.position.inside}{A numeric vector of length two setting the
placement of legends that have the \code{"inside"} position.}

\item{legend.direction}{layout of items in legends ("horizontal" or
"vertical")}

\item{legend.byrow}{whether the legend-matrix is filled by columns
(\code{FALSE}, the default) or by rows (\code{TRUE}).}

\item{legend.justification}{anchor point for positioning legend inside plot
("center" or two-element numeric vector) or the justification according to
the plot area when positioned outside the plot}

\item{legend.justification.top, legend.justification.bottom, legend.justification.left, legend.justification.right, legend.justification.inside}{Same as \code{legend.justification} but specified per \code{legend.position} option.}

\item{legend.location}{Relative placement of legends outside the plot as a
string. Can be \code{"panel"} (default) to align legends to the panels or
\code{"plot"} to align legends to the plot as a whole.}

\item{legend.box}{arrangement of multiple legends ("horizontal" or
"vertical")}

\item{legend.box.just}{justification of each legend within the overall
bounding box, when there are multiple legends ("top", "bottom", "left",
"right", "center" or "centre")}

\item{legend.box.margin}{margins around the full legend area, as specified
using \code{\link[ggplot2:margin]{margin()}}; inherits from \code{margins}.}

\item{legend.box.background}{background of legend area (\code{\link[ggplot2:element_rect]{element_rect()}};
inherits from \code{rect})}

\item{legend.box.spacing}{The spacing between the plotting area and the
legend box (\code{unit}); inherits from \code{spacing}.}

\item{panel.background}{background of plotting area, drawn underneath plot
(\code{\link[ggplot2:element_rect]{element_rect()}}; inherits from \code{rect})}

\item{panel.border}{border around plotting area, drawn on top of plot so that
it covers tick marks and grid lines. This should be used with
\code{fill = NA}
(\code{\link[ggplot2:element_rect]{element_rect()}}; inherits from \code{rect})}

\item{panel.spacing, panel.spacing.x, panel.spacing.y}{spacing between facet
panels (\code{unit}). \code{panel.spacing.x} & \code{panel.spacing.y} inherit from \code{panel.spacing}
or can be specified separately. \code{panel.spacing} inherits from \code{spacing}.}

\item{panel.grid, panel.grid.major, panel.grid.minor, panel.grid.major.x, panel.grid.major.y, panel.grid.minor.x, panel.grid.minor.y}{grid lines (\code{\link[ggplot2:element_line]{element_line()}}). Specify major grid lines,
or minor grid lines separately (using \code{panel.grid.major} or \code{panel.grid.minor})
or individually for each axis (using \code{panel.grid.major.x}, \code{panel.grid.minor.x},
\code{panel.grid.major.y}, \code{panel.grid.minor.y}).  Y axis grid lines are horizontal
and x axis grid lines are vertical. \verb{panel.grid.*.*} inherits from
\verb{panel.grid.*} which inherits from \code{panel.grid}, which in turn inherits
from \code{line}}

\item{panel.ontop}{option to place the panel (background, gridlines) over
the data layers (\code{logical}). Usually used with a transparent or blank
\code{panel.background}.}

\item{panel.widths, panel.heights}{Sizes for panels (\code{units}). Can be a
single unit to set the total size for the panel area, or a unit vector to
set the size of individual panels.}

\item{plot.background}{background of the entire plot (\code{\link[ggplot2:element_rect]{element_rect()}};
inherits from \code{rect})}

\item{plot.title}{plot title (text appearance) (\code{\link[ggplot2:element_text]{element_text()}}; inherits
from \code{title}) left-aligned by default}

\item{plot.title.position, plot.caption.position}{Alignment of the plot title/subtitle
and caption.  The setting for \code{plot.title.position} applies to both
the title and the subtitle. A value of "panel" (the default) means that
titles and/or caption are aligned to the plot panels. A value of "plot" means
that titles and/or caption are aligned to the entire plot (minus any space
for margins and plot tag).}

\item{plot.subtitle}{plot subtitle (text appearance) (\code{\link[ggplot2:element_text]{element_text()}};
inherits from \code{title}) left-aligned by default}

\item{plot.caption}{caption below the plot (text appearance)
(\code{\link[ggplot2:element_text]{element_text()}}; inherits from \code{title}) right-aligned by default}

\item{plot.tag}{upper-left label to identify a plot (text appearance)
(\code{\link[ggplot2:element_text]{element_text()}}; inherits from \code{title}) left-aligned by default}

\item{plot.tag.position}{The position of the tag as a string ("topleft",
"top", "topright", "left", "right", "bottomleft", "bottom", "bottomright")
or a coordinate. If a coordinate, can be a numeric vector of length 2 to
set the x,y-coordinate relative to the whole plot. The coordinate option
is unavailable for \code{plot.tag.location = "margin"}.}

\item{plot.tag.location}{The placement of the tag as a string, one of
\code{"panel"}, \code{"plot"} or \code{"margin"}. Respectively, these will place the tag
inside the panel space, anywhere in the plot as a whole, or in the margin
around the panel space.}

\item{plot.margin}{margin around entire plot (\code{unit} with the sizes of
the top, right, bottom, and left margins); inherits from \code{margin}.}

\item{strip.background, strip.background.x, strip.background.y}{background of facet labels (\code{\link[ggplot2:element_rect]{element_rect()}};
inherits from \code{rect}). Horizontal facet background (\code{strip.background.x})
& vertical facet background (\code{strip.background.y}) inherit from
\code{strip.background} or can be specified separately}

\item{strip.clip}{should strip background edges and strip labels be clipped
to the extend of the strip background? Options are \code{"on"} to clip, \code{"off"}
to disable clipping or \code{"inherit"} (default) to take the clipping setting
from the parent viewport.}

\item{strip.placement}{placement of strip with respect to axes,
either "inside" or "outside". Only important when axes and strips are
on the same side of the plot.}

\item{strip.text, strip.text.x, strip.text.y, strip.text.x.top, strip.text.x.bottom, strip.text.y.left, strip.text.y.right}{facet labels (\code{\link[ggplot2:element_text]{element_text()}}; inherits from  \code{text}). Horizontal facet labels (\code{strip.text.x}) & vertical
facet labels (\code{strip.text.y}) inherit from \code{strip.text} or can be specified
separately. Facet strips have dedicated position-dependent theme elements
(\code{strip.text.x.top}, \code{strip.text.x.bottom}, \code{strip.text.y.left}, \code{strip.text.y.right})
that inherit from \code{strip.text.x} and \code{strip.text.y}, respectively.
As a consequence, some theme stylings need to be applied to
the position-dependent elements rather than to the parent elements}

\item{strip.switch.pad.grid, strip.switch.pad.wrap}{space between strips and
axes when strips are switched (\code{unit}); inherits from \code{spacing}.}

\item{complete}{set this to \code{TRUE} if this is a complete theme, such as
the one returned by \code{\link[ggplot2:theme_grey]{theme_grey()}}. Complete themes behave
differently when added to a ggplot object. Also, when setting
\code{complete = TRUE} all elements will be set to inherit from blank
elements.}

\item{validate}{\code{TRUE} to run \code{check_element()}, \code{FALSE} to bypass checks.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{scheme_theme()} serves as the default theme and will always be overridden by
any \code{theme()} settings applied directly to the plot. The default theme
(\code{scheme_theme()}) is applied first, followed by any specific \code{theme()}
settings, even if \code{theme()} is added before \code{scheme_theme()}.
}
\section{Theme inheritance}{


Theme elements inherit properties from other theme elements hierarchically.
For example, \code{axis.title.x.bottom} inherits from \code{axis.title.x} which inherits
from \code{axis.title}, which in turn inherits from \code{text}. All text elements inherit
directly or indirectly from \code{text}; all lines inherit from
\code{line}, and all rectangular objects inherit from \code{rect}.
This means that you can modify the appearance of multiple elements by
setting a single high-level component.

Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.

}

\examples{
set.seed(123)
small_mat <- matrix(rnorm(56), nrow = 8)
ggheatmap(small_mat) +
    scheme_theme(plot.background = element_rect(fill = "red"))

# `scheme_theme()` serves as the default theme and will always be
# overridden by any `theme()` settings applied directly to the plot
ggheatmap(small_mat) +
    theme(plot.background = element_rect(fill = "blue")) +
    scheme_theme(plot.background = element_rect(fill = "red"))

}
\seealso{
\code{\link[ggplot2:add_gg]{add_gg()}} and \link[ggplot2]{\%+replace\%},
\code{\link[ggplot2:element_blank]{element_blank()}}, \code{\link[ggplot2:element_line]{element_line()}},
\code{\link[ggplot2:element_rect]{element_rect()}}, and \code{\link[ggplot2:element_text]{element_text()}} for
details of the specific theme elements.

The \href{https://ggplot2-book.org/themes#modifying-theme-components}{modifying theme components} and \href{https://ggplot2-book.org/themes#sec-theme-elements}{theme elements sections} of the online ggplot2 book.
}
