% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-grob.R
\name{as_grob.trellis}
\alias{as_grob.trellis}
\title{Convert Object into a Grob}
\usage{
\method{as_grob}{trellis}(x, ..., device = NULL)
}
\arguments{
\item{x}{An object to be converted into a \code{\link[grid:grid.grob]{grob}}.}

\item{...}{
  Arguments passed on to \code{\link[grid:grid.grab]{grid::grid.grabExpr}}
  \describe{
    \item{\code{warn}}{ An integer specifying the amount of warnings
    to emit.  0 means no warnings, 1 means warn when it is
    certain that the grab will not faithfully represent the
    original scene. 2 means warn if there's any possibility
    that the grab will not faithfully represent the
    original scene.
  }
    \item{\code{wrap}}{ A logical indicating how the output should
    be captured. If \code{TRUE}, each non-grob element on the
    display list is captured by wrapping it in a grob.
  }
    \item{\code{wrap.grobs}}{ A logical indicating whether, if we are wrapping
    elements (\code{wrap=TRUE}), we should wrap grobs (or just
    wrap viewports).
  }
    \item{\code{width,height}}{ Size of the device used for temporary
    rendering. }
  }}

\item{device}{ A function that opens a graphics device for temporary
    rendering. By default this is an off-screen, in-memory device
    based on the \code{pdf} device, but this default device may not be
    satisfactory when using custom fonts.
  }
}
\value{
A \code{\link[grid:grid.grob]{grob}} object.
}
\description{
Convert Object into a Grob
}
\section{\code{as_grob} method collections}{

\itemize{
\item \code{\link[=as_grob.grob]{as_grob.grob()}}
\item \code{\link[=as_grob.gList]{as_grob.gList()}}
\item \code{\link[=as_grob.patch_ggplot]{as_grob.patch_ggplot()}}
\item \code{\link[=as_grob.ggplot]{as_grob.ggplot()}}
\item \code{\link[=as_grob.ggalign::alignpatches]{as_grob.ggalign::alignpatches()}}
\item \code{\link[=as_grob.patchwork]{as_grob.patchwork()}}
\item \code{\link[=as_grob.patch]{as_grob.patch()}}
\item \code{\link[=as_grob.formula]{as_grob.formula()}}
\item \code{\link[=as_grob.recordedplot]{as_grob.recordedplot()}}
\item \code{\link[=as_grob.trellis]{as_grob.trellis()}}
\item \code{\link[=as_grob.Heatmap]{as_grob.Heatmap()}}
\item \code{\link[=as_grob.pheatmap]{as_grob.pheatmap()}}
}
}

\seealso{
\code{\link[lattice:trellis.object]{trellis}}

Other as_grob: 
\code{\link{as_grob.Heatmap}()},
\code{\link{as_grob.formula}()},
\code{\link{as_grob.gList}()},
\code{\link{as_grob.ggalign::alignpatches}()},
\code{\link{as_grob.ggplot}()},
\code{\link{as_grob.grob}()},
\code{\link{as_grob.patch}()},
\code{\link{as_grob.patch_ggplot}()},
\code{\link{as_grob.patchwork}()},
\code{\link{as_grob.pheatmap}()},
\code{\link{as_grob.recordedplot}()}
}
\concept{as_grob}
