% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_gesla.R
\name{write_gesla}
\alias{write_gesla}
\title{Write a GESLA dataset}
\usage{
write_gesla(x, file_name = "gesla-data", ...)
}
\arguments{
\item{x}{An object of class \code{ArrowObject} or \code{data.frame}}

\item{file_name}{The name of the file to be created. Must be
provided without extension, as this will be determined by the class
of \code{x}.}

\item{...}{Other arguments from \code{\link[arrow:write_csv_arrow]{arrow::write_csv_arrow()}}, and
\code{\link[arrow:write_parquet]{arrow::write_parquet()}}, from the
\href{https://arrow.apache.org/docs/r/}{arrow} package.}
}
\value{
A file with extension \code{.csv}, if \code{x} is a \code{data.frame}, or a
file with extension \code{.parquet}, if \code{x} is an \code{ArrowObject}
}
\description{
Write a CSV or Parquet file. Given an object \code{x}, this
function will write a file in the appropriate format to store this
object in the hard drive, facilitating it's reading in any other
session.

The only accepted classes of \code{x} are \code{ArrowObject} or \code{data.frame}.
If \code{x} is an \code{ArrowObject}, then the resulting file will have the
\code{.parquet} extension, in the \href{https://parquet.apache.org}{Apache Parquet} file format. If \code{x} is a
\code{data.frame}, the file will have a standard \code{.csv} extension.

This function is usefull to save objects created by the
\code{query_gesla()} function, for example. However, it may be used in
any case where saving a (possible subset) of the GESLA dataset may
be needed.
}
\details{
We highly recommend to always use the \code{ArrowObject} class,
as it will be much more efficient for dealing with it in R. Also,
the resulting file (with \code{.parquet} extension) from objects of this
type will be much smaller than CSV files created from \code{data.frame}
objects.
}
\examples{
##------------------------------------------------------------------
## Import an internal example Parquet file
## Reading file
tmp <- tempdir()
file.copy(system.file(
    "extdata", "ireland.parquet", package = "geslaR"), tmp)
da <- read_gesla(paste0(tmp, "/ireland.parquet"))
## Generates a subset by filtering
db <- da |>
    filter(day == 1) |>
    collect()
## Save filtered data as file
write_gesla(db, file_name = paste0(tmp, "/gesla-data"))

##------------------------------------------------------------------
## Querying some data
## Make the query
if(interactive()) {
    da <- query_gesla(country = "IRL", year = 2019,
        site_name = "Dublin_Port")
    ## Save the resulting query to file
    write_gesla(da, file_name = paste0(tmp, "/gesla-data"))
}

## Remove files from temporary directory
unlink(paste0(tmp, "/gesla-data.csv"))
unlink(paste0(tmp, "/gesla-data.parquet"))
unlink(paste0(tmp, "/ireland.parquet"))
}
\author{
Fernando Mayer \email{fernando.mayer@mu.ie}
}
