% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gerda_covariates.R
\name{gerda_covariates}
\alias{gerda_covariates}
\title{Get County-Level Covariates from INKAR}
\usage{
gerda_covariates()
}
\value{
A data frame with 11,200 rows and 32 columns containing county-level
covariates for 400 German counties from 1995 to 2022. See
\code{\link{gerda_covariates_codebook}} for variable descriptions.
}
\description{
Returns county-level socioeconomic and demographic covariates from INKAR.
This function provides flexible access to the raw covariate data for
advanced users who want to inspect or manipulate it before merging with
county-level election data.

For most users, we recommend using \code{\link{add_gerda_covariates}} instead,
which automatically performs the merge with correct join keys.

\strong{Note}: These covariates are at the county (Kreis) level and should be
merged with county-level GERDA data (e.g., \code{federal_cty_harm}).
}
\details{
The dataset includes 30 socioeconomic and demographic variables:
\itemize{
\item Demographics: Age structure, foreign population, gender
\item Economy: GDP, sectoral composition, enterprise structure
\item Labor Market: Unemployment rates (overall, youth, long-term)
\item Education: School completion rates, students, apprentices
\item Income: Purchasing power, low-income households
\item Healthcare: Physician density, hospital beds, GP density
\item Childcare: Coverage rates for under-3 and 3-6 age groups
\item Housing: Building permits, rent levels, living space
\item Transport: Cars per capita
\item Public Finances: Municipal debt, tax revenue
}

County codes are formatted as 5-digit AGS codes matching GERDA's harmonized
county codes (2021 boundaries).
}
\examples{
# Get the covariates data
covs <- gerda_covariates()

# Inspect the data
head(covs)
summary(covs)

# Manual merge (advanced)
library(dplyr)
elections <- load_gerda_web("federal_cty_harm")
merged <- elections \%>\%
  left_join(covs, by = c("county_code" = "county_code", "election_year" = "year"))

}
\seealso{
\itemize{
\item \code{\link{add_gerda_covariates}} for automatic merging (recommended)
\item \code{\link{gerda_covariates_codebook}} for variable descriptions
}
}
