% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestfit.R
\name{slopemeans}
\alias{slopemeans}
\title{Determines the Average Slope Along Larger Segments of
the Bearing Area Curve}
\usage{
slopemeans(slopes, l = 0.4)
}
\arguments{
\item{slopes}{A dataframe containing all slopes along
the bearing area curve, calculated using the slopecalc
function.}

\item{l}{Percentage of the curve over which to calculate
mean slope.}
}
\value{
A dataframe with the average slope over segments
beginning at specified x locations along the bearing area
curve. 'slope' represents the mean slope over the segment,
'xstart' is the beginning x location of the segment, and
'xend' is the concluding x location of the segment.
}
\description{
Calculates the average slope over every segment
of a specified percentage length of the total bearing
area curve.
}
\examples{
# import raster image
data(normforest)
normforest <- terra::unwrap(normforest)

# find the average slope of segments of the bearing area
# curve.
ba <- bearing_area(normforest)
x <- seq(0, 1, length.out = 10000)
slopes <- slopecalc(x = x, h = 0.01, f = ba)
slopes_forty <- slopemeans(slopes = slopes, l = 0.4)
}
