% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearingarea.R
\name{sdc}
\alias{sdc}
\title{Height Intervals of the Bearing Area Curve}
\usage{
sdc(x, low, high)
}
\arguments{
\item{x}{A raster or matrix.}

\item{low}{Numeric value along the x-axis corresponding
to the lowest value of interest along the x-axis.}

\item{high}{Numeric value along the y-axis corresponding
to the highest value of interest along the x-axis.}
}
\value{
A numeric value of the difference in height of
  the y values along the bearing area curve corresponding
  to the specified x values.
}
\description{
Determines the height interval (height distance) for
points along the bearing area curve as defined by
their x values.
}
\examples{
# import raster image
data(normforest)
normforest <- terra::unwrap(normforest)

# determine the 10-40\% height interval of the
# bearing area curve
val <- sdc(normforest, 0.1, 0.4)
}
