% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fftshift.R
\name{fftshift}
\alias{fftshift}
\title{Fourier Transform Shift}
\usage{
fftshift(x, dim = -1)
}
\arguments{
\item{x}{An n x n Fourier transform matrix.}

\item{dim}{Which dimension to shift the matrix. -1 swaps up/down and
left/right. 1 swaps up/down. 2 swaps left/right.}
}
\value{
An n x n matrix with the zero-frequency component of
  the Fourier transform in the center.
}
\description{
This function serves to shift the zero-frequency component of the
Fourier transform to the center of the matrix.
}
\examples{
# import raster image
data(normforest)
normforest <- terra::unwrap(normforest)

# convert to matrix form
M <- ncol(normforest)
N <- nrow(normforest)
zmat <- matrix(terra::values(normforest), ncol = M, nrow = N, byrow = TRUE)

# calculate fourier transform and shift
ftmat <- fft(zmat)
ftshift <- fftshift(ftmat)

# plot real component
r <- terra::setValues(normforest, Re(ftshift))
terra::plot(r)
}
\references{
#' This function was created from code posted by rayryeng at:
https://stackoverflow.com/questions/38230794/how-to-write-fftshift-and-ifftshift-in-r.
}
