% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/power_function_linear_environment_interaction_logistic_mle.R
\name{ll.ge.logistic.lin.envir}
\alias{ll.ge.logistic.lin.envir}
\title{Function to output log likelihood for logistic outcome with linear environment variables}
\usage{
ll.ge.logistic.lin.envir(
  sd_e,
  N = NULL,
  MAF,
  power = NULL,
  beta0,
  OR_G,
  OR_E,
  OR_GE,
  Alpha,
  True.Model,
  Test.Model
)
}
\arguments{
\item{sd_e}{Standard deviation of the environmental variable}

\item{N}{desired sample size}

\item{MAF}{Vector of minor allele frequencies}

\item{power}{desired power}

\item{beta0}{the beta0 coefficient in the logistic model}

\item{OR_G}{Vector of genetic odds ratios to detect}

\item{OR_E}{Vector of environmental odds ratios to detect}

\item{OR_GE}{Vector of genetic/environmental interaction odds ratios to detect}

\item{Alpha}{the desired type 1 error rate(s)}

\item{True.Model}{A vector specifying the true underlying genetic model(s): 'Dominant', 'Additive', 'Recessive' or 'All'}

\item{Test.Model}{A vector specifying the assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive' or 'All'}
}
\value{
a function to be used as the integrand for the mle
}
\description{
Returns the standard deviation of y given x for linear models with linear environment interaction
}
\examples{
ll.ge.logistic.lin.envir(sd_e = 1, MAF = 0.2, N = 30, beta0 = -1.462531, OR_G = 1.1, 
	OR_E = 1.2, OR_GE = 1.5, Alpha = 0.05, True.Model = "Dominant", Test.Model = "Dominant")
}
