library(testthat)

test_that("rss.sign.test works as expected",{
  set.seed(123)
  rss.data<-rss.simulation(H=3,nsamp=c(6,8,10),dist="normal", rho=0.8,delta=0)
  result=rss.sign.test(data=rss.data, alpha=0.05, alternative="two.sided", median0=0)
  expect_equal(result$RSS_median, -0.0922, tolerance = 1e-3)
  expect_equal(result$sign, 12, tolerance = 1e-3)
  expect_equal(result$p.value, 0.4385, tolerance = 1e-3)
  expect_equal(result$CI, c(-0.3059,0.3796), tolerance = 1e-3)
  expect_equal(result$z, -0.7745, tolerance = 1e-3)

})

test_that("rss.sign.test handles wrong input with error",{
  rss.data=rss.simulation(H=3,nsamp=c(6,7,8),dist="normal", rho=0.8,delta=0)
  expect_error(rss.sign.test(data=rss.data, alpha=1.1,alternative="two.sided", median0=0),
               "alpha is out of bound.")
  expect_error(rss.sign.test(data=rss.data, alpha=0.05,alternative="one-sided", median0=0),
               "Invalid alternative selected. Please choose from 'two.sided', 'less', or 'greater'.")
  expect_error(rss.sign.test(data=rss.data[,1], alpha=0.05,alternative="two.sided", median0=0),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.sign.test(data=rss.data[,2], alpha=0.05,alternative="two.sided", median0=0),
               "The input data must contain 'rank' and 'y' variables.")
})
