% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gencor.R
\name{gencor}
\alias{gencor}
\title{Generates custom correlation matrices}
\usage{
gencor(
  d = 10,
  method = c("random", "low", "medium", "high", "custom"),
  custom_prop = NULL,
  nsim = 1000,
  lim_low = 0.3,
  lim_medium = 0.6,
  custom_lim = NULL,
  signal = c("random", "positive"),
  custom_precision = 0.03,
  custom_nrep = 1000,
  sort_intensity = F,
  random_liminf = 0.01,
  seed = NULL
)
}
\arguments{
\item{d}{Dimension of the generated matrix. If not informed, \code{d} = 10}

\item{method}{The method of matrix generation.
\itemize{
 \item "\code{random}": generates a random matrix with the given dimension;
 \item "\code{low}": generates a matrix of values between \code{-lim_low} and   \code{lim_low};
 \item "\code{medium}": generates a matrix of values in the interval \cr \code{[-lim\_medium, -lim\_low) U (lim\_low, lim\_medium]};
 \item "\code{high}": generates a matrix of values between \code{lim_medium} and 1.
 \item "\code{custom}": Generates a matrix given the custom limits and proportions of each band defined by the limits.
}}

\item{custom_prop}{Vector with custom proportions for every band defined by \code{lim_low} and \code{lim_medium} or \code{custom_lim}. If not defined, the proportions will be equally distributed among the correlation bands.}

\item{nsim}{Size of vectors used to generate the correlation matrix.}

\item{lim_low}{The lower limit of generated correlations. Applied in \code{low} and \code{medium} methods by standard and in \code{custom} method if \code{custom_lim} are not informed.}

\item{lim_medium}{The medium limit of generated correlations. Applied in \code{low} and \code{medium} methods and in \code{custom} method if \code{custom_lim} are not informed.}

\item{custom_lim}{Number or numeric vector with customized limits to generate the correlation matrix.}

\item{signal}{Defines if the signals of the correlation matrix must be chosen at random or all must be positive.
\itemize{
 \item "\code{positive}": generates a correlation matrix with all correlations positive. Some negative signals may occur for correlations sufficiently near         zero.
 \item "\code{random}": generates a correlation matrix with random signals
}}

\item{custom_precision}{The precision used in \code{custom} method. It is the maximum difference between \code{custom_prop} and the proportions generated by the function}

\item{custom_nrep}{The number of iterations in the optimization method used to generate custom correlation matrices.}

\item{sort_intensity}{Sorts the correlation matrix by intensity.}

\item{random_liminf}{Sets the lower limit of uniform distribution that generates the standard deviations used in random correlation matrix generation. Must be greater than zero due to convergence problems.}

\item{seed}{Enables seed definition.}
}
\value{
\code{gencor(...)} returns an object of class "gencor" with a list of the following objects:
\itemize{

\item Matrix - The generated correlation matrix.
\item Method - The method used in generation
\item Proportions - The observed proportions at each level. The levels are given by default or user defined.
\item Runtime - Ellapsed simulation time
\item Nsim - Number of iterations needed to achieve the desired correlation matrix. 0 if the chosen method was "random".
\item Precision - The precision used on the  optimization method.
\item Dimension - The dimension of the generated correlation matrix.
\item Sdev - Vector of standard deviations used in generation process.
\item Custom_propp - User defined proportions in custom method. NULL if the chosen method was random.
\item custom_lim - User defined correlation limits in custom method. NULL if the chosen method was random.
\item Signal - Type of signal generation defined by the user, "random" by default.
\item Nrep - Size of simulated data matrix used in correlation matrix generation.
\item Generated data - Simulated data used in the generation process.

}
}
\description{
This method generates custom correlation matrices based on user-defined limits and/or proportions.
}
\details{
This method generates correlation matrices based on the correlations among normal random variables with mean 0 and specified standard deviation values. These specified standard deviation values make possible the control of the correlation coefficient intensity.
}
\examples{

## Generates a random correlation matrix with dimension 10
gencor()

## Generates a correlation matrix with correlations below 0.3 
gencor(15, method = "low", lim_low = 0.3)

## Generates a correlation matrix with correlations between 0.3 and 0.7
gencor(15, method = "medium", lim_low = 0.3, lim_medium = 0.7)

## Generates a correlation matrix with correlations above 0.7
gencor(30, method = "high", lim_medium = 0.75)

## Generates a custom correlation matrix with: 
## - 30\% of values below 0.2, 
## - 30\% of values between 0.2 and 0.5,
## - 20\% of values between 0.5 and 0.8,
## - 20\% of values above 0.8
gencor(20, method = "custom", custom_lim = c(0.2, 0.5, 0.8), custom_prop = c(0.3, 0.3, 0.2, 0.2))


}
