% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_SEIQRDP.R
\name{predict_SEIQRDP}
\alias{predict_SEIQRDP}
\title{Predict cases using generalized SEIR model}
\usage{
predict_SEIQRDP(
  country,
  start,
  finish,
  Npop = NULL,
  guess,
  dt = 1,
  f = 0,
  boot = FALSE,
  conf = 0.95,
  seed = 123,
  repeatNumber = 200,
  bootSample = NULL,
  type = "norm"
)
}
\arguments{
\item{country}{name of the country. It should be a character string.}

\item{start}{a start date in mm/dd/yy format. Start date can not be earlier than 01/22/20. Start date can not be later than finish date. If start date is \code{NULL} then start date will be 01/22/20.}

\item{finish}{a finish date in mm/dd/yy format. Finish date can not be earlier than start date. If finish date is \code{NULL} then finish date will be the latest date at John-Hopkins CSSE system.}

\item{Npop}{total population of the country}

\item{guess}{initial guess parameters}

\item{dt}{the time step. This oversamples time to ensure that the algorithm converges}

\item{f}{number of days for future predictions}

\item{boot}{if \code{TRUE} bootstrap will be performed to calculate confidence interval}

\item{conf}{confidence level, default is 0.95.}

\item{seed}{set a seed for reproducible results.}

\item{repeatNumber}{number of iteration for bootstrap.}

\item{bootSample}{number of sample for each bootstrap. if \code{NULL} then the number of sample is 80 percent of the original data.}

\item{type}{a condidence interval type. If \code{"norm"} it calculates based on normal approximation, if \code{"perc"} it calculates based on percentile approximation,}
}
\value{
a list of predicted and actual cases.
}
\description{
This function predicts cases of an outbreak using a generalized SEIR model
}
\examples{
\donttest{
alpha_guess = 0.45
beta_guess = 1
LT_guess = 2
Q_guess = 0.55
lambda_guess = c(0.01,0.01,30)
kappa_guess = c(0.01,0.001,30)

guess = list(alpha_guess,
            beta_guess,
            1/LT_guess,
            Q_guess,
            lambda_guess[1],
            lambda_guess[2],
            lambda_guess[3],
            kappa_guess[1],
            kappa_guess[2],
            kappa_guess[3])


pred = predict_SEIQRDP(country = "Germany", start = "10/15/20", finish = "12/15/20",
dt = 1, f = 30, conf = 0.95, Npop = 80000000, guess, boot = FALSE,
seed = 123, repeatNumber = 100, bootSample = NULL, type = "norm")

predict = pred$pred
actual = pred$actual
}
}
\references{
Peng, L., Yang, W., Zhang, D., Zhuge, C., Hong, L. 2020. “Epidemic analysis of COVID-19 in China by dynamical modeling”, arXiv preprint arXiv:2002.06563.

\url{https://www.mathworks.com/matlabcentral/fileexchange/74545-generalized-seir-epidemic-model-fitting-and-computation}
}
\seealso{
\code{\link{SEIQRDP}} \code{\link{fit_SEIQRDP}}
}
\author{
Selcuk Korkmaz, \email{selcukorkmaz@gmail.com}
}
