% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getKappaFun.R
\name{getKappaFun}
\alias{getKappaFun}
\title{Estimate Death Rate}
\usage{
getKappaFun(
  tTarget,
  Q,
  D,
  guess,
  ftol,
  ptol,
  gtol,
  epsfcn,
  factor,
  maxfev,
  maxiter,
  nprint,
  trace
)
}
\arguments{
\item{tTarget}{time vector}

\item{Q}{target time-histories of the quarantined cases}

\item{D}{target time-histories of the dead cases}

\item{guess}{initial guess parameters for kappa}

\item{ftol}{nls.lm.control object. non-negative numeric. Default is \code{1e-6}}

\item{ptol}{nls.lm.control object. non-negative numeric. Default is \code{1e-6}}

\item{gtol}{nls.lm.control object. non-negative numeric. Default is \code{1e-6}}

\item{epsfcn}{nls.lm.control object. Default is \code{0.001}}

\item{factor}{nls.lm.control object. Default is \code{100}}

\item{maxfev}{nls.lm.control object. Default is \code{1000}}

\item{maxiter}{nls.lm.control object. Default is \code{100}}

\item{nprint}{nls.lm.control object. Default is \code{1}}

\item{trace}{Set \code{TRUE} to trace iteration results}
}
\value{
vector of estimation and optimization function for the death rate
}
\description{
This function provides a first estimate of the  death rate, to faciliate
convergence of the main algorithm.
}
\references{
Peng, L., Yang, W., Zhang, D., Zhuge, C., Hong, L. 2020. “Epidemic analysis of COVID-19 in China by dynamical modeling”, arXiv preprint arXiv:2002.06563.

\url{https://www.mathworks.com/matlabcentral/fileexchange/74545-generalized-seir-epidemic-model-fitting-and-computation}
}
\seealso{
\code{\link{SEIQRDP}} \code{\link{fit_SEIQRDP}}
}
\author{
Selcuk Korkmaz, \email{selcukorkmaz@gmail.com}
}
