% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_u.R
\name{update_u}
\alias{update_u}
\title{Update U matrix}
\usage{
update_u(OmegaE, UltVehiY, UltVehiBX)
}
\arguments{
\item{OmegaE}{the OmegaE matrix, calculated in calc_omega}

\item{UltVehiY}{matrix}

\item{UltVehiBX}{matrix}
}
\description{
Update U matrix
}
\examples{
readr::read_tsv(system.file("extdata",
"mouse100.pheno.txt",
package = "gemma2"),
col_names = FALSE) -> pheno
phe16 <- as.matrix(pheno[, c(1, 6)])
as.matrix(readr::read_tsv(system.file("extdata",
"mouse100.cXX.txt",
package = "gemma2"),
col_names = FALSE)[, 1:100]) -> kinship
eigen2(kinship) -> e2_out
e2_out$values -> eval
e2_out$vectors -> U
eigen_proc(V_g = diag(c(1.91352, 0.530827)),
V_e = diag(c(0.320028, 0.561589))) -> ep_out
UltVehi <- ep_out[[3]]
calc_omega(eval, ep_out$D_l) -> co_out
update_u(OmegaE = co_out[[2]],
        UltVehiY = UltVehi \%*\% t(phe16),
        UltVehiBX = matrix(c(-0.71342, -0.824482),
        ncol = 1) \%*\% t(rep(1, 100))
)
}
\seealso{
Other expectation-maximization functions: 
\code{\link{UpdateRL_B}()},
\code{\link{update_e}()},
\code{\link{update_v}()}
}
\concept{expectation-maximization functions}
