% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmult.R
\name{gmult}
\alias{gmult}
\title{Linear Transformation of a Generalized Ellipsoid}
\usage{
gmult(A, G, epsfac = 2)
}
\arguments{
\item{A}{A matrix describing a linear transformation, conforming to the U
component of \code{G} for matrix multiplication.}

\item{G}{A \code{gell} object}

\item{epsfac}{Factor of \code{.Machine$double.eps} used to distinguish zero
vs. positive singular values}
}
\value{
\code{gell} object
}
\description{
Linear transformation of a generalized ellipsoid, including projections to
subspaces.
}
\details{
The matrix \code{A} can be non-singular, for a standard linear
transformation, or singular, for a projection to a subspace.
}
\note{
This implementation should be changed so that it provides an S3 method
            for class \code{"gell"} objects for which it was intended.
}
\examples{

(zplane <- gell(span = diag(3)[,1:2]))  # a plane

dual(zplane)  # orthogonal line
(zplane2 <- gmult( cbind( c(1,1,1), c(1,-1,0), c(1,0,-1)), zplane))

# correctly wipes out one dimension
(zplane3 <- gmult( cbind( c(1,0,0), c(1,0,0), c(0,0,1)), zplane)) 


}
\seealso{
\code{\link{gell}}, \code{\link{dual}}, \code{\link{signature}}
}
\author{
Georges Monette
}
\keyword{algebra}
\keyword{dplot}
