% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geboes_score_binary.R
\name{geboes_score_binary}
\alias{geboes_score_binary}
\title{Convert a Geboes score from the original value to a normal/abnormal value}
\usage{
geboes_score_binary(x)
}
\arguments{
\item{x}{A character vector of Geboes score grades}
}
\value{
A character vector the same length as \code{x} with "normal" or "abnormal"
}
\description{
Values <= "3.1" or ending with ".0" are considered "normal"; values > "3.1"
are considered abnormal based on Li 2019.
}
\examples{
geboes_score_binary(c("3.1", "4.0", "3.2")) # c("Normal", "Normal", "Abnormal")
}
\references{
Li K, Strauss R, Marano C, et al. A Simplified Definition of
Histologic Improvement in Ulcerative Colitis and its Association With
Disease Outcomes up to 30 Weeks from Initiation of Therapy: Post Hoc
Analysis of Three Clinical Trials. Journal of Crohn’s and Colitis.
2019;13(8):1025-1035. doi:10.1093/ecco-jcc/jjz022
}
