% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbif_local.R
\name{gbif_local}
\alias{gbif_local}
\title{Local connection to a downloaded GBIF Parquet database}
\usage{
gbif_local(
  dir = gbif_parquet_dir(version = gbif_version(local = TRUE)),
  tblname = "gbif",
  backend = c("arrow", "duckdb"),
  safe = TRUE
)
}
\arguments{
\item{dir}{location of downloaded GBIF parquet files}

\item{tblname}{name for the database table}

\item{backend}{choose duckdb or arrow.}

\item{safe}{logical. Should we exclude columns \code{mediatype}
and \code{issue}? (default \code{TRUE}).
varchar datatype on these columns substantially slows downs queries.}
}
\value{
a remote tibble \code{tbl_sql} class object
}
\description{
Local connection to a downloaded GBIF Parquet database
}
\details{
A summary of this GBIF data, along with column meanings can be found at
\url{https://github.com/gbif/occurrence/blob/master/aws-public-data.md}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

gbif <- gbif_local(gbif_example_data())
\dontshow{\}) # examplesIf}
}
