% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tight_frame.R
\name{tight_frame}
\alias{tight_frame}
\title{Tight-Frame Computation}
\usage{
tight_frame(
  evalues,
  evectors,
  b = 2,
  filter_func = zetav,
  filter_params = list()
)
}
\arguments{
\item{evalues}{Numeric vector containing the eigenvalues of the Laplacian matrix.}

\item{evectors}{Matrix of the corresponding eigenvectors of the Laplacian matrix.}

\item{b}{Numeric scalar. Parameter that controls the number of scales in the wavelet decomposition.}

\item{filter_func}{Function used to compute the filter values. By default, it uses the \code{\link{zetav}} function but other frame filters can be passed.}

\item{filter_params}{List of additional parameters required by filter_func. Default is an empty list.}
}
\value{
Matrix of the tight-frame wavelet coefficients.
}
\description{
Constructs a tight-frame wavelet on graphs
}
\note{
\code{tight_frame} can be adapted for other filters by passing a different filter function to the \code{filter_func} parameter.
The computation of \eqn{k_{\text{max}}}{k_max} using \eqn{\lambda_{\text{max}}}{lambda_max} and \eqn{b}{b} applies primarily to the default \code{zetav} filter. It can be overridden by providing it in the \code{filter_params} list for other filters.
}
\examples{
\dontrun{
# Extract the adjacency matrix from the grid1 and compute the Laplacian
L <- laplacian_mat(grid1$sA)

# Compute the spectral decomposition of L
decomp <- eigensort(L)

# Generate the tight frame coefficients using the tight_frame function
tf <- tight_frame(decomp$evalues, decomp$evectors)
}

}
\references{
Coulhon, T., Kerkyacharian, G., & Petrushev, P. (2012). Heat kernel generated frames in the setting of Dirichlet spaces. Journal of Fourier Analysis and Applications, 18(5), 995-1066.

Göbel, F., Blanchard, G., von Luxburg, U. (2018). Construction of tight frames on graphs and application to denoising. In Handbook of Big Data Analytics (pp. 503-522). Springer, Cham.

Leonardi, N., & Van De Ville, D. (2013). Tight wavelet frames on multislice graphs. IEEE Transactions on Signal Processing, 61(13), 3357-3367.

de Loynes, B., Navarro, F., Olivier, B. (2021). Data-driven thresholding in denoising with Spectral Graph Wavelet Transform. Journal of Computational and Applied Mathematics, Vol. 389.
}
