% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fullup.R
\name{fullup}
\alias{fullup}
\title{Convert Symmetric Sparse Matrix to Full Matrix}
\usage{
fullup(sA)
}
\arguments{
\item{sA}{Matrix (sparseMatrix). Symmetric upper triangular matrix to be converted.}
}
\value{
\code{A} Full symmetric matrix.
}
\description{
\code{fullup} converts a symmetric sparse matrix \code{sA}, stored as an upper triangular matrix, to a full matrix \code{A}.
}
\details{
This function can be used for transforming matrices that have been stored in a memory-efficient format (i.e., the upper triangle portion of a symmetric matrix) to their full format. The conversion is done either by directly transforming the sparse matrix or by leveraging the \code{\link{full}} function.
}
\examples{
data(grid1)
A <- fullup(grid1$sA)
}
\seealso{
\code{\link{full}}
}
