% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.gapclosing.R
\name{as.data.frame.gapclosing}
\alias{as.data.frame.gapclosing}
\title{Coerce to a Data Frame}
\usage{
\method{as.data.frame}{gapclosing}(x, ...)
}
\arguments{
\item{x}{Object of class \code{gapclosing}, produced by a call to \code{gapclosing()}.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
A data frame containing estimates.
}
\description{
This function converts a \code{gapclosing} object into a data frame. The gapclosing class contains results within a named list, thus simplifying things for manual user interaction with the results. In some programming settings (e.g. a bootstrap), it is easier to work with a rectangular data frame of results. This function produces that data frame.
}
\examples{
# Simulate example data
simulated_data <- generate_simulated_data(n = 100)

# Fit by outcome modeling
estimate <- gapclosing(
  data = simulated_data,
  outcome_formula = formula(outcome ~ treatment * category + confounder),
  treatment_name = "treatment",
  category_name = "category",
  counterfactual_assignments = 1
)
summary(estimate)

# Convert to a data frame
estimate.df <- as.data.frame(estimate)
}
\references{
Lundberg I (2021). "The gap-closing estimand: A causal approach to study interventions that close disparities across social categories." Sociological Methods and Research. Available at {https://osf.io/gx4y3/}.
}
