% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fw_geosites.R
\name{fw_geosites}
\alias{fw_geosites}
\title{Auto generation of species sites}
\usage{
fw_geosites(x, dist = 1000)
}
\arguments{
\item{x}{\code{dataframe} Geo spatial data with geometry column from sf package.}

\item{dist}{\code{integer} The distance used to cluster points as sites. The default is 1000.}
}
\value{
dataframe
}
\description{
Auto generation of species sites
}
\examples{

\dontrun{
geospdata <- speciesdata |>
sf::st_as_sf(coords = c('decimalLongitude', 'decimalLatitude'),
            crs = sf::st_crs(4326))
 xx <- fw_geosites(geospdata)
}

}
