% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myrng.R
\name{myrng}
\alias{myrng}
\title{Set seed for the MATLAB random number generator}
\usage{
myrng(seed)
}
\arguments{
\item{seed}{a single value, interpreted as an integer}
}
\value{
Integer, the seed value with which the MATLAB random number generator was initialized.
}
\description{
Initializes the MATLAB random generator
}
\examples{

 \dontrun{
   data(wool)
   XX <- wool
   y <- XX[, ncol(XX)]
   X <- XX[, 1:(ncol(XX)-1), drop=FALSE]

   seed <- myrng()                       #i nitialized the RNG and keep the seed

   myrng(seed)                           # repeat the computations with the same seed
   (out2 <- fsreg(X, y, method="LTS"))

   all.equal(out1, out2)

 }

}
\author{
FSDA team, \email{valentin.todorov@chello.at}
}
