% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a.R
\name{importance}
\alias{importance}
\alias{importance.fru}
\title{Extract importance}
\usage{
importance(x, ...)

\method{importance}{fru}(x, scale = FALSE, ...)
}
\arguments{
\item{x}{A model from which importance scores should be extracted; has to hold importance scores (\code{importance=TRUE} flag passed to \code{fru}).}

\item{...}{Ignored.}

\item{scale}{If \code{TRUE}, importance scores will be scaled their standard deviation over the ensemble.}
}
\value{
A vector of importance scores, in the order and named as columns were in the training data.
}
\description{
Extracts importance from the \code{fru} model.
}
\note{
Other packages often scale importance by its standard error estimate, thus producing scales importance values square root of tree count times larger than fru.
If you get a "non applicable method" error, this method was probably shadowed by other package.
Use \code{fru:::importance} to call this function explicitly.
}
\examples{
set.seed(1)
data(iris)
fru(iris[,-5],iris[,5],threads=2,importance=TRUE)->model
importance(model)
}
