% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_surface.R
\name{polygon.soup.to.indexed.mesh}
\alias{polygon.soup.to.indexed.mesh}
\title{Turn polygon soup into indexed mesh.}
\usage{
polygon.soup.to.indexed.mesh(faces_vertex_coords, digits = 6)
}
\arguments{
\item{faces_vertex_coords}{numerical matrix with *n* rows and 3 columns, the vertex coordinates of the faces. Each row contains the x,y,z coordinates of a single vertex, and three consecutive vertex rows form a triangular face.}

\item{digits}{the precision (number of digits after decimal separator) to use when to determine whether two x,y,z coords define the same vertex.}
}
\value{
an indexed mesh, as an `fs.surface` instance (see \code{\link[freesurferformats]{read.fs.surface}}).
}
\description{
Some mesh file formats like STL do not store the faces as indices into a vertex list ('indexed mesh'), but repeat all vertex coordinates for each face ('polygon soup'). This function creates an indexed mesh from a polysoup.
}
\keyword{internal}
