\name{draw.treeRK}
\alias{draw.treeRK}
\title{
 Creates a \code{igraph} plot of a \code{rktree}
}
\usage{
 draw.treeRK(tr = construct.treeRK(), y.factor.levels,
 font = "Times", node.colour = "white", text.colour = "dark blue",
 text.size = 0.67, tree.vertex.size = 75, tree.title = "Diagram of a Tree",
 title.colour = "dark blue")
}
\arguments{
 \item{tr}{
 	a \code{construct.treeRK()} object (a tree).
 }

 \item{y.factor.levels}{
 	a \code{y.organizer()$y.factor.levels} output.
 }

 \item{font}{
 	font type used in the \code{rktree} plot; default is "Times".
 }

 \item{node.colour}{
 	colour of the node used in the \code{rktree} plot; default is "White".
 }

 \item{text.colour}{
 	colour of the text used in the \code{rktree} plot; default is "Dark Blue".
 }

 \item{text.size}{
 	size of the text in the \code{rktree} plot; default is 0.67.
 }

 \item{tree.vertex.size}{
 	size of the \code{rktree} plot vertices; default is 75.
 }

 \item{tree.title}{
 	title of the \code{rktree} plot; default title is "Diagram of a Tree".
 }

 \item{title.colour}{
 	colour for the title of the \code{rktree} plot;
 	default title colour is "Dark Blue".
 }
}
\value{
 An \code{igraph} plot of a \code{rktree}.
}
\description{
 Creates a plot of a \code{rktree} that was built from the (training) dataset.

 The package \code{igraph} is loaded internally when this function is called,
 to aid in generating the plot of a \code{rktree}.


 DESCRIPTIONS OF THE \code{rktree} PLOT:

 The resulting plot is a classical decision tree.

 The rectangular nodes (or vertices) that contain "=<" symbol are used to
 describe the splitting criteria applied to that very node while constructing
 the \code{rktree}; for example, in the \code{rktree} plot generated by the code
 shown in the "examples" section below, the node with the label
 "Petal.Width =< 1.6" indicates that this node was split into a chunk that
 contains observations with Petal.Width <= 1.6 and a chunk that contains
 observations with Petal.Width greater than 1.6, in order to construct the
 \code{rktree}.

 Any other rectangular nodes (or vertices) that do not contain the "=<" symbol
 indicate that we have reached an end node, and the text displayed in such node
 is the actual name of the class type that the rktree model assigns to the
 observations belonging to that node; for example, in the \code{rktree} plot
 generated by the code shown in the "examples" section below, the vertex with
 the label "setosa" indicates that the \code{rktree} assigns the class type
 "setosa" to all observations that belong to that particular node.
}
\examples{
  ## example: iris dataset
  ## load the forestRK package
  library(forestRK)

  ## Numericize the data
  x.train <- x.organizer(iris[,1:4], encoding = "num")[c(1:25,51:75,101:125),]
  y.train <- y.organizer(iris[c(1:25,51:75,101:125),5])$y.new
  y.factor.levels <- y.organizer(iris[c(1:25,51:75,101:125),5])$y.factor.levels

  ## Construct a tree
  # min.num.obs.end.node.tree is set to 5 by default;
  # entropy is set to TRUE by default
  tree.entropy <- construct.treeRK(x.train, y.train)

  # Plot the tree
  draw.treeRK(tree.entropy, y.factor.levels, font="Times",
              node.colour = "black", text.colour = "white", text.size = 0.7,
              tree.vertex.size = 100, tree.title = "Decision Tree",
              title.colour = "dark green")
}
\author{
 Hyunjin Cho, \email{h56cho@uwaterloo.ca}
 Rebecca Su, \email{y57su@uwaterloo.ca}
}
\seealso{
\code{\link{mds.plot.forestRK}}
\code{\link{importance.plot.forestRK}}
}
\keyword{plot}
\keyword{treeRK}
\keyword{tree.plot}
