% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt.R
\name{fmt}
\alias{fmt}
\title{Variance estimation of FMT method (Fully Moderated T-statistic)}
\usage{
fmt(
  Amean,
  sigmasq,
  df,
  span1 = 0.5,
  span2 = 0.95,
  iter1 = 4,
  iter2 = 4,
  b = 20
)
}
\arguments{
\item{Amean}{average log intensity levels of all genes}

\item{sigmasq}{residual variances of all genes}

\item{df}{degrees of freedom for sigmasq}

\item{span1}{span parameter in LOESS smoothing function, default is 0.5}

\item{span2}{span parameter in LOESS smoothing function, default is 0.95}

\item{iter1}{iteration number in LOESS smoothing function, default is 4}

\item{iter2}{iteration number in LOESS smoothing function, default is 4}

\item{b}{number of genes on either side of moving average
window when calculating variance of log residual variances,
default is 20}
}
\value{
A data frame with the following components:

 'df.prior' the estimated prior degrees of freedom.

 'df.post' the estimated posterior degrees of freedom.

 's2.prior' the estimated prior variance.

 's2.post' the estimated posterior variance.

 'Ameansort' intermediate result.

 'eg' intermediate result.

 'egpred' intermediate result.

 'MAvar' intermediate result.

 'tri.d0' intermediate result.
}
\description{
This function computes posterior residual variances to be used
in the denominator of a moderated t-statistic from a linear model
analysis of gene expression data. It is an extension of the moderated
t-statistic originally proposed by Smyth (Statistical Applications in
Genetics and Molecular Biology, 2004;3:Article3). LOESS local regression
and empirical Bayesian method are used to estimate gene specific prior
degrees of freedom and prior variance based on average gene intensity levels.
The posterior residual variance in the denominator is a weighted average of
prior and residual variance and the weights are prior degrees of freedom
and residual variance degrees of freedom. The degrees of freedom of the
moderated t-statistic is simply the sum of prior and residual variance
degrees of freedom.
}
\examples{
## Simulate gene expression data for 1000 genes and 10 samples in two groups.
exp <- rnorm(1000,8,2)
sd <- 0.5*sqrt(4/rchisq(1000, df=7))
y <- matrix(rnorm(1000*10, exp, sd),1000,10)
rownames(y) <- paste("Gene",1:1000)
design <- cbind(Grp1=1, Grp2vs1=c(0,0,0,0,0,1,1,1,1,1))

## limma fit
fit <- lmFit(y,design)

## fmt fit
fmt.fit <- fmt(fit$Amean, fit$sigma, fit$df.residual)

}
