% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{hrf_fourier_generator}
\alias{hrf_fourier_generator}
\title{Create Fourier HRF Basis Set}
\usage{
hrf_fourier_generator(nbasis = 5, span = 24)
}
\arguments{
\item{nbasis}{Number of basis functions (default: 5). Should be even for complete sine-cosine pairs.}

\item{span}{Temporal window in seconds (default: 24)}
}
\value{
An HRF object of class \code{c("Fourier_HRF", "HRF", "function")}
}
\description{
Generates an HRF object using Fourier basis functions (sine and cosine pairs)
with custom parameters.
}
\details{
The Fourier basis uses alternating sine and cosine functions with increasing
frequencies. This provides a smooth, periodic basis set that can capture
oscillatory components in the HRF.
}
\examples{
# Create Fourier basis with 8 functions
custom_fourier <- hrf_fourier_generator(nbasis = 8)
t <- seq(0, 24, by = 0.1)
response <- evaluate(custom_fourier, t)
matplot(t, response, type = "l", main = "Fourier HRF with 8 basis functions")
}
\seealso{
\code{\link{HRF_objects}} for pre-defined HRF objects,
  \code{\link{getHRF}} for a unified interface to create HRFs
}
