% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_flocker_data.R
\name{make_flocker_data_augmented}
\alias{make_flocker_data_augmented}
\title{#' Format data for data-augmented occupancy model, to be passed to 
 \code{flock()}.}
\usage{
make_flocker_data_augmented(
  obs,
  n_aug,
  site_covs = NULL,
  event_covs = NULL,
  quiet = FALSE
)
}
\arguments{
\item{obs}{An I x J x K array where rows I are sites, columns J are 
repeat sampling events, and slices K are species. Allowable values are 1 
(detection), 0 (no detection), and NA (no sampling event).
 The data must be formatted so that all NAs are trailing within their rows.}

\item{n_aug}{Number of pseudospecies to augment}

\item{site_covs}{A dataframe of covariates for each site that are constant 
across repeated sampling events.}

\item{event_covs}{A named list of I x J matrices, each one corresponding to a 
covariate that varies across repeated sampling events within sites}

\item{quiet}{Hide progress bars and informational messages?}
}
\value{
A flocker_data list that can be passed as data to \code{flocker()}.
}
\description{
#' Format data for data-augmented occupancy model, to be passed to 
 \code{flock()}.
}
