% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{getBlockCov}
\alias{getBlockCov}
\title{Covariance Computations Between Pairs of Distances (Block Dependencies Case)}
\usage{
getBlockCov(X, block_boundaries, block_labels, p)
}
\arguments{
\item{X}{The binary or real matrix}

\item{block_boundaries}{Vector denoting the positions where a new
block of non-independent features starts.}

\item{block_labels}{Length \eqn{P} vector recording the block label of each feature.}

\item{p}{The power \eqn{p} of \eqn{l_p^p}, i.e., \eqn{||x||_p^p = (x_1^p+...x_n^p)}}
}
\value{
The three distinct entries of covariance matrix, \eqn{(\alpha, \beta, \gamma)}
}
\description{
Computes covariance matrix entries and associated alpha, beta
and gamma quantities defined in Aw, Spence and Song (2023),
for partitionable features that are grouped into blocks. Uses
precomputation to compute the unique entries of the asymptotic
covariance matrix of the pairwise Hamming distances in \eqn{O(N^2)} time.
}
\details{
This is used in the large \eqn{P} asymptotics of the permutation test.

Dependencies: buildReverse, getHammingDistance, getLpDistance
}
