% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom-funs.R
\name{glance.flexsurvreg}
\alias{glance.flexsurvreg}
\title{Glance at a flexsurv model object}
\usage{
\method{glance}{flexsurvreg}(x, ...)
}
\arguments{
\item{x}{Output from \code{\link{flexsurvreg}} or \code{\link{flexsurvspline}}, representing a fitted survival model object.}

\item{...}{Not currently used.}
}
\value{
A one-row \code{\link[tibble]{tibble}} containing columns:
\itemize{
\item \code{N} Number of observations used in fitting
\item \code{events} Number of events
\item \code{censored} Number of censored events
\item \code{trisk} Total length of time-at-risk (i.e. follow-up)
\item \code{df} Degrees of freedom (i.e. number of estimated parameters)
\item \code{logLik} Log-likelihood
\item \code{AIC} Akaike's "An Information Criteria"
\item \code{BIC} Bayesian Information Criteria
}
}
\description{
Glance accepts a model object and returns a tibble with exactly one row of model summaries.
}
\examples{
fitg <- flexsurvreg(formula = Surv(futime, fustat) ~ age, data = ovarian, dist = "gengamma")
glance(fitg)

}
